package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

import static com.zurrtum.create.Create.MOD_ID;

public record SpoutFillingDisplay(
    EntryIngredient input, EntryIngredient fluid, EntryIngredient output, Optional<class_2960> location
) implements Display {
    public static final class_2960 POTIONS = class_2960.method_60655(MOD_ID, "potions");
    public static final DisplaySerializer<SpoutFillingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(SpoutFillingDisplay::input),
            EntryIngredient.codec().fieldOf("fluid").forGetter(SpoutFillingDisplay::fluid),
            EntryIngredient.codec().fieldOf("output").forGetter(SpoutFillingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(SpoutFillingDisplay::location)
        ).apply(instance, SpoutFillingDisplay::new)), class_9139.method_56905(
            EntryIngredient.streamCodec(),
            SpoutFillingDisplay::input,
            EntryIngredient.streamCodec(),
            SpoutFillingDisplay::fluid,
            EntryIngredient.streamCodec(),
            SpoutFillingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            SpoutFillingDisplay::location,
            SpoutFillingDisplay::new
        )
    );

    public SpoutFillingDisplay(class_8786<FillingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public SpoutFillingDisplay(class_2960 id, FillingRecipe recipe) {
        this(
            EntryIngredients.ofIngredient(recipe.ingredient()),
            IngredientHelper.createEntryIngredient(recipe.fluidIngredient()),
            EntryIngredients.of(recipe.result()),
            Optional.of(id)
        );
    }

    public static void register(Stream<EntryStack<?>> itemStream, Stream<EntryStack<?>> fluidStream, DisplayConsumer registry) {
        List<FluidStack> fluids = fluidStream.map(entry -> {
            dev.architectury.fluid.FluidStack stack = entry.castValue();
            return new FluidStack(stack.getFluid(), stack.getAmount(), stack.method_57353().method_57940());
        }).toList();
        itemStream.forEach(entry -> {
            class_1799 stack = entry.castValue();
            if (PotionFluidHandler.isPotionItem(stack)) {
                registry.add(new SpoutFillingDisplay(
                    EntryIngredients.of(class_1802.field_8469),
                    IngredientHelper.createEntryIngredient(PotionFluidHandler.getFluidFromPotionItem(stack)),
                    EntryIngredients.of(stack),
                    Optional.of(POTIONS)
                ));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972())) {
                if (capability == null) {
                    return;
                }
                int size = capability.size();
                FluidStack existingFluid = size == 1 ? capability.getStack(0) : FluidStack.EMPTY;
                for (FluidStack fluid : fluids) {
                    if (size == 1 && !existingFluid.isEmpty() && !FluidStack.areFluidsAndComponentsEqual(existingFluid, fluid)) {
                        continue;
                    }
                    int insert = capability.insert(fluid, 81000);
                    if (insert == 0) {
                        continue;
                    }
                    class_1799 result = capability.getContainer();
                    if (!result.method_7960()) {
                        class_1792 item = stack.method_7909();
                        if (!result.method_31574(item)) {
                            class_2960 itemName = class_7923.field_41178.method_10221(item);
                            class_2960 fluidName = class_7923.field_41173.method_10221(fluid.getFluid());
                            class_2960 id = class_2960.method_60655(
                                MOD_ID,
                                "fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()
                            );
                            registry.add(new SpoutFillingDisplay(
                                EntryIngredients.of(stack),
                                EntryIngredients.of(dev.architectury.fluid.FluidStack.create(fluid.getFluid(), insert, fluid.getComponentChanges())),
                                EntryIngredients.of(result),
                                Optional.of(id)
                            ));
                        }
                    }
                    capability.extract(fluid, insert);
                }
            }
        });
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input, fluid);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.SPOUT_FILLING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
