package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.catnip.data.WorldAttached;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.*;
import net.minecraft.class_1937;
import net.minecraft.class_5568;

public class ContraptionHandler {

    /* Global map of loaded contraptions */

    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions;
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions;

    static {
        loadedContraptions = new WorldAttached<>($ -> new HashMap<>());
        queuedAdditions = new WorldAttached<>($ -> ObjectLists.synchronize(new ObjectArrayList<>()));
    }

    public static void tick(class_1937 world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get(world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get(world);

        for (AbstractContraptionEntity contraptionEntity : queued)
            map.put(contraptionEntity.method_5628(), new WeakReference<>(contraptionEntity));
        queued.clear();

        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        for (Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator(); iterator.hasNext(); ) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = weakReference.get();
            if (contraptionEntity == null || !contraptionEntity.isAliveOrStale()) {
                iterator.remove();
                continue;
            }
            if (!contraptionEntity.method_5805()) {
                contraptionEntity.staleTicks--;
                continue;
            }

            ContraptionCollider.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(class_5568 entity) {
        if (entity instanceof AbstractContraptionEntity abstractContraptionEntity)
            queuedAdditions.get(abstractContraptionEntity.method_37908()).add(abstractContraptionEntity);
    }

}
