package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.minecart.MinecartSim2020;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity.CartMovementMode;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4844;

/**
 * Ex: Minecarts, Couplings <br>
 * Oriented Contraption Entities can rotate freely around two axes
 * simultaneously.
 */
public class OrientedContraptionEntity extends AbstractContraptionEntity {

    private static final class_1856 FUEL_ITEMS = class_1856.method_8091(class_1802.field_8713, class_1802.field_8665);

    private static final class_2940<Optional<UUID>> COUPLING = class_2945.method_12791(
        OrientedContraptionEntity.class,
        AllSynchedDatas.OPTIONAL_UUID_HANDLER
    );
    private static final class_2940<class_2350> INITIAL_ORIENTATION = class_2945.method_12791(
        OrientedContraptionEntity.class,
        class_2943.field_13321
    );

    protected class_243 motionBeforeStall;
    protected boolean forceAngle;
    private boolean attachedExtraInventories;
    private boolean manuallyPlaced;

    public float prevYaw;
    public float yaw;
    public float targetYaw;

    public float prevPitch;
    public float pitch;

    public int nonDamageTicks;

    public OrientedContraptionEntity(class_1299<? extends OrientedContraptionEntity> type, class_1937 world) {
        super(type, world);
        motionBeforeStall = class_243.field_1353;
        attachedExtraInventories = false;
        nonDamageTicks = 10;
    }

    public static OrientedContraptionEntity create(class_1937 world, Contraption contraption, class_2350 initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity(AllEntityTypes.ORIENTED_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(class_1937 world, Contraption contraption, class_2350 initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(class_2350 direction) {
        field_6011.method_12778(INITIAL_ORIENTATION, direction);
    }

    public class_2350 getInitialOrientation() {
        return field_6011.method_12789(INITIAL_ORIENTATION);
    }

    @Override
    public float getYawOffset() {
        return getInitialYaw();
    }

    public float getInitialYaw() {
        return (isInitialOrientationPresent() ? field_6011.method_12789(INITIAL_ORIENTATION) : class_2350.field_11035).method_10144();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COUPLING, Optional.empty());
        builder.method_56912(INITIAL_ORIENTATION, class_2350.field_11036);
    }

    @Override
    public ContraptionRotationState getRotationState() {
        ContraptionRotationState crs = new ContraptionRotationState();

        float yawOffset = getYawOffset();
        crs.zRotation = pitch;
        crs.yRotation = -yaw + yawOffset;

        if (pitch != 0 && yaw != 0) {
            crs.secondYRotation = -yaw;
            crs.yRotation = yawOffset;
        }

        return crs;
    }

    @Override
    public void method_5848() {
        if (!method_37908().field_9236 && method_5805())
            disassemble();
        super.method_5848();
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);

        view.method_71426("InitialOrientation", class_2350.field_29502).ifPresent(this::setInitialOrientation);

        yaw = view.method_71423("Yaw", 0);
        pitch = view.method_71423("Pitch", 0);
        manuallyPlaced = view.method_71433("Placed", false);

        float forceYaw = view.method_71423("ForceYaw", -1);
        if (forceYaw != -1) {
            startAtYaw(forceYaw);
        }

        view.method_71426("CachedMotion", class_243.field_38277).ifPresent(motion -> {
            motionBeforeStall = motion;
            if (!motionBeforeStall.equals(class_243.field_1353))
                targetYaw = prevYaw = yaw += yawFromVector(motionBeforeStall);
            method_18799(class_243.field_1353);
        });

        setCouplingId(view.method_71426("OnCoupling", class_4844.field_25122).orElse(null));
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);

        if (motionBeforeStall != null)
            view.method_71468("CachedMotion", class_243.field_38277, motionBeforeStall);

        class_2350 optional = field_6011.method_12789(INITIAL_ORIENTATION);
        if (optional.method_10166().method_10179())
            view.method_71468("InitialOrientation", class_2350.field_29502, optional);
        if (forceAngle) {
            view.method_71464("ForceYaw", yaw);
            forceAngle = false;
        }

        view.method_71472("Placed", manuallyPlaced);
        view.method_71464("Yaw", yaw);
        view.method_71464("Pitch", pitch);

        if (getCouplingId() != null)
            view.method_71468("OnCoupling", class_4844.field_25122, getCouplingId());
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (INITIAL_ORIENTATION.equals(key) && isInitialOrientationPresent() && !manuallyPlaced)
            startAtInitialYaw();
    }

    public boolean isInitialOrientationPresent() {
        return field_6011.method_12789(INITIAL_ORIENTATION).method_10166().method_10179();
    }

    public void startAtInitialYaw() {
        startAtYaw(getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        targetYaw = this.yaw = prevYaw = yaw;
        forceAngle = true;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, getInitialYaw(), class_2351.field_11052);
        localPos = VecHelper.rotate(localPos, getViewXRot(partialTicks), class_2351.field_11051);
        localPos = VecHelper.rotate(localPos, getViewYRot(partialTicks), class_2351.field_11052);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -getViewYRot(partialTicks), class_2351.field_11052);
        localPos = VecHelper.rotate(localPos, -getViewXRot(partialTicks), class_2351.field_11051);
        localPos = VecHelper.rotate(localPos, -getInitialYaw(), class_2351.field_11052);
        return localPos;
    }

    public float getViewYRot(float partialTicks) {
        return -(partialTicks == 1.0F ? yaw : AngleHelper.angleLerp(partialTicks, prevYaw, yaw));
    }

    public float getViewXRot(float partialTicks) {
        return partialTicks == 1.0F ? pitch : AngleHelper.angleLerp(partialTicks, prevPitch, pitch);
    }

    @Override
    protected void tickContraption() {
        if (nonDamageTicks > 0)
            nonDamageTicks--;
        class_1297 e = method_5854();
        if (e == null)
            return;

        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = isStalled();
        if (contraption instanceof MountedContraption mountedContraption) {
            rotationLock = mountedContraption.rotationMode == CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartMovementMode.ROTATE_PAUSED;
        }

        class_1297 riding = e;
        while (riding.method_5854() != null && !(contraption instanceof StabilizedContraption))
            riding = riding.method_5854();

        boolean isOnCoupling = false;
        UUID couplingId = getCouplingId();
        isOnCoupling = couplingId != null && riding instanceof class_1688;

        if (!attachedExtraInventories) {
            attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            attachedExtraInventories = true;
        }

        boolean rotating = updateOrientation(rotationLock, wasStalled, riding, isOnCoupling);
        if (!rotating || !pauseWhileRotating)
            tickActors();
        boolean isStalled = isStalled();
        boolean isClient = method_37908().field_9236;

        boolean isUpdate = true;
        if (riding instanceof class_1688) {
            Optional<MinecartController> data = AllSynchedDatas.MINECART_CONTROLLER.get(riding);
            if (data.isPresent()) {
                if (!isClient) {
                    data.get().setStalledExternally(isStalled);
                }
                isUpdate = false;
            }
        }
        if (isUpdate) {
            if (isStalled) {
                if (!wasStalled)
                    motionBeforeStall = riding.method_18798();
                riding.method_18800(0, 0, 0);
            }
            if (wasStalled && !isStalled) {
                riding.method_18799(motionBeforeStall);
                motionBeforeStall = class_243.field_1353;
            }
        }

        if (isClient)
            return;

        if (!isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = getCoupledCartsIfPresent();
                if (coupledCarts == null)
                    return;
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    private class_2338 getCurrentRailPosition(class_1688 entity) {
        int x = class_3532.method_15357(entity.method_23317());
        int y = class_3532.method_15357(entity.method_23318());
        int z = class_3532.method_15357(entity.method_23321());
        class_2338 pos = new class_2338(x, y, z);
        if (entity.method_37908().method_8320(pos.method_10074()).method_26164(class_3481.field_15463))
            pos = pos.method_10074();
        return pos;
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, class_1297 riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = getCoupledCartsIfPresent();
            if (coupledCarts == null)
                return false;

            class_243 positionVec = coupledCarts.getFirst().cart().method_19538();
            class_243 coupledVec = coupledCarts.getSecond().cart().method_19538();

            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;

            prevYaw = yaw;
            prevPitch = pitch;
            yaw = (float) (class_3532.method_15349(diffZ, diffX) * 180 / Math.PI);
            pitch = (float) (Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180 / Math.PI);

            if (getCouplingId().equals(riding.method_5667())) {
                pitch *= -1;
                yaw += 180;
            }
            return false;
        }

        if (contraption instanceof StabilizedContraption stabilized) {
            if (!(riding instanceof OrientedContraptionEntity parent))
                return false;
            class_2350 facing = stabilized.getFacing();
            if (facing.method_10166().method_10178())
                return false;
            prevYaw = yaw;
            yaw = AngleHelper.wrapAngle180(getInitialYaw() - parent.getInitialYaw()) - parent.getViewYRot(1);
            return false;
        }

        prevYaw = yaw;
        if (wasStalled)
            return false;

        boolean rotating = false;
        class_243 movementVector = riding.method_18798();
        class_243 locationDiff = riding.method_19538().method_1023(riding.field_6014, riding.field_6036, riding.field_5969);
        if (!(riding instanceof class_1688))
            movementVector = locationDiff;
        class_243 motion = movementVector.method_1029();

        if (!rotationLock) {
            if (riding instanceof class_1688 minecartEntity) {
                class_2338 railPosition = getCurrentRailPosition(minecartEntity);
                class_2680 blockState = method_37908().method_8320(railPosition);
                if (blockState.method_26204() instanceof class_2241 abstractRailBlock) {
                    class_2768 railDirection = blockState.method_11654(abstractRailBlock.method_9474());
                    motion = VecHelper.project(motion, MinecartSim2020.getRailVec(railDirection));
                }
            }

            if (motion.method_1033() > 0) {
                targetYaw = yawFromVector(motion);
                if (targetYaw < 0)
                    targetYaw += 360;
                if (yaw < 0)
                    yaw += 360;
            }

            prevYaw = yaw;
            float maxApproachSpeed = (float) (motion.method_1033() * 12f / (Math.max(1, method_5829().method_17939() / 6f)));
            float yawHint = AngleHelper.getShortestAngleDiff(yaw, yawFromVector(locationDiff));
            float approach = AngleHelper.getShortestAngleDiff(yaw, targetYaw, yawHint);
            approach = class_3532.method_15363(approach, -maxApproachSpeed, maxApproachSpeed);
            yaw += approach;
            if (Math.abs(AngleHelper.getShortestAngleDiff(yaw, targetYaw)) < 1f)
                yaw = targetYaw;
            else
                rotating = true;
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(class_1297 riding) {
        if (!(riding instanceof class_1696 furnaceCart))
            return;

        int fuel = furnaceCart.field_7739;
        int fuelBefore = fuel;
        double pushX = furnaceCart.field_54300.field_1352;
        double pushZ = furnaceCart.field_54300.field_1350;

        int i = class_3532.method_15357(furnaceCart.method_23317());
        int j = class_3532.method_15357(furnaceCart.method_23318());
        int k = class_3532.method_15357(furnaceCart.method_23321());
        if (furnaceCart.method_37908().method_8320(new class_2338(i, j - 1, k)).method_26164(class_3481.field_15463))
            --j;

        class_2338 blockpos = new class_2338(i, j, k);
        if (method_37908().method_8320(blockpos).method_26164(class_3481.field_15463))
            if (fuel > 1)
                riding.method_18799(riding.method_18798().method_1029().method_1021(1));
        if (fuel < 5 && contraption != null) {
            MountedItemStorageWrapper fuelItems = contraption.getStorage().getFuelItems();
            if (fuelItems != null) {
                class_1799 coal = fuelItems.extract(FUEL_ITEMS, 1);
                if (!coal.method_7960())
                    fuel += 3600;
            }
        }

        if (fuel != fuelBefore || pushX != 0 || pushZ != 0) {
            furnaceCart.field_54300 = new class_243(pushX, 0.0, pushZ);
            furnaceCart.field_7739 = fuel;
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = getCouplingId();
        if (couplingId == null)
            return null;
        MinecartController controller = CapabilityMinecartController.getIfPresent(method_37908(), couplingId);
        if (controller == null || !controller.isPresent())
            return null;
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(method_37908(), coupledCart);
        if (coupledController == null || !coupledController.isPresent())
            return null;
        return Couple.create(controller, coupledController);
    }

    protected void attachInventoriesFromRidingCarts(class_1297 riding, boolean isOnCoupling, UUID couplingId) {
        if (!(contraption instanceof MountedContraption mc))
            return;
        if (!isOnCoupling) {
            mc.addExtraInventories(riding);
            return;
        }
        Couple<MinecartController> coupledCarts = getCoupledCartsIfPresent();
        if (coupledCarts == null)
            return;
        coupledCarts.map(MinecartController::cart).forEach(mc::addExtraInventories);
    }

    @Nullable
    public UUID getCouplingId() {
        return field_6011.method_12789(COUPLING).orElse(null);
    }

    public void setCouplingId(UUID id) {
        field_6011.method_12778(COUPLING, Optional.ofNullable(id));
    }

    @Override
    public class_243 method_55668(class_1297 entity) {
        return entity instanceof AbstractContraptionEntity ? class_243.field_1353 : new class_243(0, 0.19, 0);
    }

    @Override
    public class_243 getAnchorVec() {
        class_243 anchorVec = super.getAnchorVec();
        return anchorVec.method_1023(.5, 0, .5);
    }

    @Override
    public class_243 getPrevAnchorVec() {
        class_243 prevAnchorVec = super.getPrevAnchorVec();
        return prevAnchorVec.method_1023(.5, 0, .5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = class_2338.method_49638(getAnchorVec().method_1031(.5, .5, .5));
        return new StructureTransform(offset, 0, -yaw + getInitialYaw(), 0);
    }

    @Override
    protected float getStalledAngle() {
        return yaw;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        yaw = angle;
    }
}
