package com.zurrtum.create.content.contraptions.actors;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public abstract class AttachedActorBlock extends class_2383 implements IWrenchable, ProperWaterloggedBlock {

    protected AttachedActorBlock(class_2251 p_i48377_1_) {
        super(p_i48377_1_);
        method_9590(method_9564().method_11657(WATERLOGGED, false));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5814;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_2350 direction = state.method_11654(field_11177);
        return AllShapes.HARVESTER_BASE.get(direction);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177, WATERLOGGED);
        super.method_9515(builder);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2350 direction = state.method_11654(field_11177);
        class_2338 offset = pos.method_10093(direction.method_10153());
        return BlockHelper.hasBlockSolidSide(worldIn.method_8320(offset), worldIn, offset, direction);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 facing;
        if (context.method_8038().method_10166().method_10178())
            facing = context.method_8042().method_10153();
        else {
            class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10093(context.method_8038().method_10153()));
            if (blockState.method_26204() instanceof AttachedActorBlock)
                facing = blockState.method_11654(field_11177);
            else
                facing = context.method_8038();
        }
        return withWater(method_9564().method_11657(field_11177, facing), context);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

}
