package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class PortableStorageInterfaceMovement extends MovementBehaviour {

    public static final String _workingPos_ = "WorkingPos";
    static final String _clientPrevPos_ = "ClientPrevPos";

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(PortableStorageInterfaceBlock.field_10927).method_62675()).method_1021(1.85f);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (onCarriage && context.motion.method_1033() > 1 / 4f)
            return;
        if (!findInterface(context, pos))
            context.data.method_10551(_workingPos_);
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_9236)
            getAnimation(context).tickChaser();

        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (onCarriage && context.motion.method_1033() > 1 / 4f)
            return;

        if (context.world.field_9236) {
            class_2338 pos = class_2338.method_49638(context.position);
            if (!findInterface(context, pos))
                reset(context);
            return;
        }

        if (!context.data.method_10545(_workingPos_)) {
            if (context.stall)
                cancelStall(context);
            return;
        }

        class_2338 pos = context.data.method_67491(_workingPos_, class_2338.field_25064).orElseThrow();
        class_243 target = VecHelper.getCenterOf(pos);

        if (!context.stall && !onCarriage && context.position.method_24802(target, target.method_1022(context.position.method_1019(context.motion))))
            context.stall = true;

        Optional<class_2350> currentFacingIfValid = getCurrentFacingIfValid(context);
        if (currentFacingIfValid.isEmpty()) {
            reset(context);
            return;
        }

        PortableStorageInterfaceBlockEntity stationaryInterface = getStationaryInterfaceAt(
            context.world,
            pos,
            context.state,
            currentFacingIfValid.get()
        );
        if (stationaryInterface == null) {
            reset(context);
            return;
        }

        if (stationaryInterface.connectedEntity == null)
            stationaryInterface.startTransferringTo(context.contraption, stationaryInterface.distance);

        boolean timerBelow = stationaryInterface.transferTimer <= PortableStorageInterfaceBlockEntity.ANIMATION;
        stationaryInterface.keepAlive = 2;
        if (context.stall && timerBelow) {
            context.stall = false;
        }
    }

    protected boolean findInterface(MovementContext context, class_2338 pos) {
        if (context.contraption instanceof CarriageContraption cc && !cc.notInPortal())
            return false;
        Optional<class_2350> currentFacingIfValid = getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent())
            return false;

        class_2350 currentFacing = currentFacingIfValid.get();
        PortableStorageInterfaceBlockEntity psi = findStationaryInterface(context.world, pos, context.state, currentFacing);

        if (psi == null)
            return false;
        if (psi.isPowered())
            return false;

        context.data.method_67494(_workingPos_, class_2338.field_25064, psi.method_11016());
        if (!context.world.field_9236) {
            class_243 diff = VecHelper.getCenterOf(psi.method_11016()).method_1020(context.position);
            diff = VecHelper.project(diff, class_243.method_24954(currentFacing.method_62675()));
            float distance = (float) (diff.method_1033() + 1.85f - 1);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.method_67494(_clientPrevPos_, class_2338.field_25064, pos);
            if (context.contraption instanceof CarriageContraption || context.contraption.entity.isStalled() || context.motion.method_1027() == 0)
                getAnimation(context).chase(psi.getConnectionDistance() / 2, 0.25f, Chaser.LINEAR);
        }

        return true;
    }

    @Override
    public void stopMoving(MovementContext context) {
        //		reset(context);
    }

    @Override
    public void cancelStall(MovementContext context) {
        reset(context);
    }

    public void reset(MovementContext context) {
        context.data.method_10551(_clientPrevPos_);
        context.data.method_10551(_workingPos_);
        context.stall = false;
        getAnimation(context).chase(0, 0.25f, Chaser.LINEAR);
    }

    private PortableStorageInterfaceBlockEntity findStationaryInterface(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        for (int i = 0; i < 2; i++) {
            PortableStorageInterfaceBlockEntity interfaceAt = getStationaryInterfaceAt(world, pos.method_10079(facing, i), state, facing);
            if (interfaceAt == null)
                continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableStorageInterfaceBlockEntity getStationaryInterfaceAt(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof PortableStorageInterfaceBlockEntity psi))
            return null;
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26204() != state.method_26204())
            return null;
        if (blockState.method_11654(PortableStorageInterfaceBlock.field_10927) != facing.method_10153())
            return null;
        if (psi.isPowered())
            return null;
        return psi;
    }

    private Optional<class_2350> getCurrentFacingIfValid(MovementContext context) {
        class_243 directionVec = class_243.method_24954(context.state.method_11654(PortableStorageInterfaceBlock.field_10927).method_62675());
        directionVec = context.rotation.apply(directionVec);
        class_2350 facingFromVector = class_2350.method_10142(directionVec.field_1352, directionVec.field_1351, directionVec.field_1350);
        if (directionVec.method_1022(class_243.method_24954(facingFromVector.method_62675())) > 1 / 2f)
            return Optional.empty();
        return Optional.of(facingFromVector);
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat lf)) {
            LerpedFloat nlf = LerpedFloat.linear();
            context.temporaryData = nlf;
            return nlf;
        }
        return lf;
    }

}
