package com.zurrtum.create.content.contraptions.elevator;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import net.minecraft.class_9904;
import net.minecraft.world.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public class ElevatorContactBlock extends WrenchableDirectionalBlock implements IBE<ElevatorContactBlockEntity>, SpecialBlockItemRequirement, RedStoneConnectBlock, WeakPowerControlBlock {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 CALLING = class_2746.method_11825("calling");
    public static final class_2746 POWERING = BrassDiodeBlock.POWERING;

    public static final MapCodec<ElevatorContactBlock> field_46280 = method_54094(ElevatorContactBlock::new);

    public ElevatorContactBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(CALLING, false).method_11657(POWERING, false).method_11657(POWERED, false).method_11657(field_10927, class_2350.field_11035));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(CALLING, POWERING, POWERED));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        if (onWrenched != class_1269.field_5812)
            return onWrenched;

        class_1937 level = context.method_8045();
        if (level.method_8608())
            return onWrenched;

        class_2338 pos = context.method_8037();
        state = level.method_8320(pos);
        class_2350 facing = state.method_11654(RedstoneContactBlock.field_10927);
        if (facing.method_10166() != class_2351.field_11052 && ElevatorColumn.get(level, new ColumnCoords(pos.method_10263(), pos.method_10260(), facing)) != null)
            return onWrenched;

        level.method_8501(pos, BlockHelper.copyProperties(state, AllBlocks.REDSTONE_CONTACT.method_9564()));

        return onWrenched;
    }

    @Nullable
    public static ColumnCoords getColumnCoords(class_1936 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        if (!blockState.method_27852(AllBlocks.ELEVATOR_CONTACT) && !blockState.method_27852(AllBlocks.REDSTONE_CONTACT))
            return null;
        class_2350 facing = blockState.method_11654(field_10927);
        class_2338 target = pos;
        return new ColumnCoords(target.method_10263(), target.method_10260(), facing);
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pBlock,
        @Nullable class_9904 wireOrientation,
        boolean pIsMoving
    ) {
        if (pLevel.field_9236)
            return;

        boolean isPowered = pState.method_11654(POWERED);
        if (isPowered == pLevel.method_49803(pPos))
            return;

        pLevel.method_8652(pPos, pState.method_28493(POWERED), class_2248.field_31028);

        if (isPowered)
            return;
        if (pState.method_11654(CALLING))
            return;

        ElevatorColumn elevatorColumn = ElevatorColumn.getOrCreate(pLevel, getColumnCoords(pLevel, pPos));
        callToContactAndUpdate(elevatorColumn, pState, pLevel, pPos, true);
    }

    public void callToContactAndUpdate(ElevatorColumn elevatorColumn, class_2680 pState, class_1937 pLevel, class_2338 pPos, boolean powered) {
        pLevel.method_8652(pPos, pState.method_28493(CALLING), class_2248.field_31028);

        for (class_2338 otherPos : elevatorColumn.getContacts()) {
            if (otherPos.equals(pPos))
                continue;
            class_2680 otherState = pLevel.method_8320(otherPos);
            if (!otherState.method_27852(AllBlocks.ELEVATOR_CONTACT))
                continue;
            pLevel.method_8652(otherPos, otherState.method_11657(CALLING, false), 2 | 16);
            scheduleActivation(pLevel, otherPos);
        }

        if (powered)
            pState = pState.method_11657(POWERED, true);
        pLevel.method_8652(pPos, pState.method_11657(CALLING, true), class_2248.field_31028);
        pLevel.method_8452(pPos, this, null);

        elevatorColumn.target(pPos.method_10264());
        elevatorColumn.markDirty();
    }

    public void scheduleActivation(class_10225 pLevel, class_2338 pPos) {
        if (!pLevel.method_8397().method_8674(pPos, this))
            pLevel.method_64310(pPos, this, 1);
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRand) {
        boolean wasPowering = pState.method_11654(POWERING);

        Optional<ElevatorContactBlockEntity> optionalBE = getBlockEntityOptional(pLevel, pPos);
        boolean shouldBePowering = optionalBE.map(be -> {
            boolean activateBlock = be.activateBlock;
            be.activateBlock = false;
            be.method_5431();
            return activateBlock;
        }).orElse(false);

        shouldBePowering |= RedstoneContactBlock.hasValidContact(pLevel, pPos, pState.method_11654(field_10927));

        if (wasPowering || shouldBePowering)
            pLevel.method_8652(pPos, pState.method_11657(POWERING, shouldBePowering), 2 | 16);

        pLevel.method_8452(pPos, this, null);
    }

    @Override
    public class_2680 method_9559(
        class_2680 stateIn,
        class_4538 worldIn,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 facing,
        class_2338 facingPos,
        class_2680 facingState,
        class_5819 random
    ) {
        if (facing != stateIn.method_11654(field_10927))
            return stateIn;
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(worldIn, currentPos, facing);
        if (stateIn.method_11654(POWERING) != hasValidContact)
            scheduleActivation(tickView, currentPos);
        return stateIn;
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return state.method_11654(POWERING);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.REDSTONE_CONTACT.method_7854();
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, @Nullable class_2350 side) {
        if (side == null)
            return true;
        return state.method_11654(field_10927) != side.method_10153();
    }

    @Override
    public int method_9524(class_2680 state, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        if (side == null)
            return 0;
        class_2680 toState = blockAccess.method_8320(pos.method_10093(side.method_10153()));
        if (toState.method_27852(this))
            return 0;
        return state.method_11654(POWERING) ? 15 : 0;
    }

    @Override
    public Class<ElevatorContactBlockEntity> getBlockEntityClass() {
        return ElevatorContactBlockEntity.class;
    }

    @Override
    public class_2591<? extends ElevatorContactBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ELEVATOR_CONTACT;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(AllBlocks.REDSTONE_CONTACT.method_9564(), be);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player != null && stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;
        if (level.field_9236) {
            withBlockEntityDo(
                level, pos, be -> {
                    AllClientHandle.INSTANCE.openElevatorContactScreen(be, player);
                }
            );
        }
        return class_1269.field_5812;
    }

    public static int getLight(class_2680 state) {
        return state.method_11654(POWERING) ? 10 : 0;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2318> method_53969() {
        return field_46280;
    }
}
