package com.zurrtum.create.content.contraptions.minecart.capability;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_5568;

public class CapabilityMinecartController {

    /* Global map of loaded carts */

    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID;
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling;
    static WorldAttached<List<class_1688>> queuedAdditions;
    static WorldAttached<List<UUID>> queuedUnloads;

    static {
        loadedMinecartsByUUID = new WorldAttached<>($ -> new HashMap<>());
        loadedMinecartsWithCoupling = new WorldAttached<>($ -> new HashSet<>());
        queuedAdditions = new WorldAttached<>($ -> ObjectLists.synchronize(new ObjectArrayList<>()));
        queuedUnloads = new WorldAttached<>($ -> ObjectLists.synchronize(new ObjectArrayList<>()));
    }

    public static void tick(class_1937 world) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(world);
        List<class_1688> queued = queuedAdditions.get(world);
        List<UUID> queuedRemovals = queuedUnloads.get(world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get(world);
        Set<UUID> keySet = carts.keySet();

        for (UUID removal : queuedRemovals) {
            keySet.remove(removal);
            cartsWithCoupling.remove(removal);
        }

        for (class_1688 cart : queued) {
            UUID uniqueID = cart.method_5667();

            if (world.field_9236 && carts.containsKey(uniqueID)) {
                MinecartController minecartController = carts.get(uniqueID);
                if (minecartController != null) {
                    class_1688 minecartEntity = minecartController.cart();
                    if (minecartEntity != null && minecartEntity.method_5628() != cart.method_5628())
                        continue; // Away with you, Fake Entities!
                }
            }

            cartsWithCoupling.remove(uniqueID);

            AllSynchedDatas.MINECART_CONTROLLER.get(cart).ifPresent(controller -> {
                carts.put(uniqueID, controller);
                if (controller.isLeadingCoupling())
                    cartsWithCoupling.add(uniqueID);
                if (!world.field_9236)
                    controller.sendData();
            });
        }

        queuedRemovals.clear();
        queued.clear();

        List<UUID> toRemove = new ArrayList<>();

        for (Map.Entry<UUID, MinecartController> entry : carts.entrySet()) {
            MinecartController controller = entry.getValue();
            if (controller != null && controller.isPresent())
                continue;
            toRemove.add(entry.getKey());
        }

        for (UUID uuid : toRemove) {
            keySet.remove(uuid);
            cartsWithCoupling.remove(uuid);
        }
    }

    public static void entityTick(class_1297 entity) {
        if (!(entity instanceof class_1688))
            return;
        AllSynchedDatas.MINECART_CONTROLLER.get(entity).ifPresent(MinecartController::tick);
    }

    public static void onChunkUnloaded(class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        class_1937 world = chunk.method_12200();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(world);
        for (MinecartController minecartController : carts.values()) {
            if (minecartController == null)
                continue;
            if (!minecartController.isPresent())
                continue;
            class_1688 cart = minecartController.cart();
            if (cart.method_31476().equals(chunkPos))
                queuedUnloads.get(world).add(cart.method_5667());
        }
    }

    protected static void onCartRemoved(class_1937 world, class_1688 entity) {
        AllSynchedDatas.MINECART_CONTROLLER.set(entity, Optional.empty());

        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(world);
        List<UUID> unloads = queuedUnloads.get(world);
        UUID uniqueID = entity.method_5667();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID))
            return;
        if (world.field_9236)
            return;
        handleKilledMinecart(world, carts.get(uniqueID), entity.method_19538());
    }

    protected static void handleKilledMinecart(class_1937 world, MinecartController controller, class_243 removedPos) {
        if (controller == null)
            return;
        for (boolean forward : Iterate.trueAndFalse) {
            Optional<MinecartController> next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next.isEmpty())
                continue;

            MinecartController nextController = next.get();
            nextController.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward))
                continue;
            class_1688 cart = nextController.cart();
            if (cart == null)
                continue;

            class_243 itemPos = cart.method_19538().method_1019(removedPos).method_1021(.5f);
            class_1542 itemEntity = new class_1542(world, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, AllItems.MINECART_COUPLING.method_7854());
            itemEntity.method_6988();
            world.method_8649(itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(class_1937 world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(world);
        if (carts == null)
            return null;
        if (!carts.containsKey(cartId))
            return null;
        return carts.get(cartId);
    }

    /* Capability management */

    public static void attach(class_5568 entity) {
        if (!(entity instanceof class_1688 abstractMinecart))
            return;

        MinecartController controller = new MinecartController(abstractMinecart);
        AllSynchedDatas.MINECART_CONTROLLER.set(abstractMinecart, Optional.of(controller));
        queuedAdditions.get(abstractMinecart.method_37908()).add(abstractMinecart);
    }

    public static void onEntityDeath(class_1937 world, class_1297 entity) {
        if (entity instanceof class_1688 abstractMinecart)
            onCartRemoved(world, abstractMinecart);
    }
}
