package com.zurrtum.create.content.contraptions.mounted;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity.CartMovementMode;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Queue;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_3499.class_3501;

import static com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock.RAIL_SHAPE;

public class MountedContraption extends Contraption {

    public CartMovementMode rotationMode;
    public class_1688 connectedCart;

    public MountedContraption() {
        this(CartMovementMode.ROTATE);
    }

    public MountedContraption(CartMovementMode mode) {
        rotationMode = mode;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.MOUNTED;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        class_2680 state = world.method_8320(pos);
        if (!state.method_28498(RAIL_SHAPE))
            return false;
        if (!searchMovedStructure(world, pos, null))
            return false;

        class_2351 axis = state.method_11654(RAIL_SHAPE) == class_2768.field_12674 ? class_2351.field_11048 : class_2351.field_11051;
        addBlock(
            world,
            pos,
            Pair.of(new class_3501(pos, AllBlocks.MINECART_ANCHOR.method_9564().method_11657(class_2741.field_12529, axis), null), null)
        );

        return blocks.size() != 1;
    }

    @Override
    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 direction, Queue<class_2338> frontier) {
        frontier.clear();
        frontier.add(pos.method_10084());
        return true;
    }

    @Override
    protected Pair<class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        Pair<class_3501, class_2586> pair = super.capture(world, pos);
        class_3501 capture = pair.getKey();
        if (!capture.comp_1342().method_27852(AllBlocks.CART_ASSEMBLER))
            return pair;

        Pair<class_3501, class_2586> anchorSwap = Pair.of(
            new class_3501(
                pos,
                CartAssemblerBlock.createAnchor(capture.comp_1342()),
                null
            ), pair.getValue()
        );
        if (pos.equals(anchor) || connectedCart != null)
            return anchorSwap;

        for (class_2351 axis : Iterate.axes) {
            if (axis.method_10178() || !VecHelper.onSameAxis(anchor, pos, axis))
                continue;
            for (class_1688 abstractMinecartEntity : world.method_18467(class_1688.class, new class_238(pos))) {
                if (!CartAssemblerBlock.canAssembleTo(abstractMinecartEntity))
                    break;
                connectedCart = abstractMinecartEntity;
                connectedCart.method_5814(pos.method_10263() + .5, pos.method_10264(), pos.method_10260() + .5f);
            }
        }

        return anchorSwap;
    }

    @Override
    protected boolean movementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        if (!pos.equals(anchor) && state.method_27852(AllBlocks.CART_ASSEMBLER))
            return testSecondaryCartAssembler(world, pos);
        return super.movementAllowed(state, world, pos);
    }

    protected boolean testSecondaryCartAssembler(class_1937 world, class_2338 pos) {
        for (class_2351 axis : Iterate.axes) {
            if (axis.method_10178() || !VecHelper.onSameAxis(anchor, pos, axis))
                continue;
            for (class_1688 abstractMinecartEntity : world.method_18467(class_1688.class, new class_238(pos))) {
                if (!CartAssemblerBlock.canAssembleTo(abstractMinecartEntity))
                    break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71468("RotationMode", CartMovementMode.CODEC, rotationMode);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        view.method_71426("RotationMode", CartMovementMode.CODEC).ifPresent(mode -> rotationMode = mode);
        super.read(world, view, spawnData);
    }

    @Override
    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        return state.method_27852(AllBlocks.MINECART_ANCHOR);
    }

    @Override
    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        return state.method_27852(AllBlocks.MINECART_ANCHOR);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return true;
    }

    public void addExtraInventories(class_1297 cart) {
        if (cart instanceof class_1263 inventory)
            storage.attachExternal(inventory);
    }


}
