package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.contraptions.*;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public abstract class LinearActuatorBlockEntity extends KineticBlockEntity implements IControlContraption {

    public float offset;
    public boolean running;
    public boolean assembleNextTick;
    public boolean needsContraption;
    public AbstractContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ServerScrollOptionBehaviour<MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected AssemblyException lastException;
    protected double sequencedOffsetLimit;

    // Custom position sync
    protected float clientOffsetDiff;

    public LinearActuatorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        setLazyTickRate(3);
        forceMove = true;
        needsContraption = true;
        sequencedOffsetLimit = -1;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        movementMode = new ServerScrollOptionBehaviour<>(MovementMode.class, this);
        movementMode.withCallback(t -> waitingForSpeedChange = false);
        behaviours.add(movementMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    protected boolean syncSequenceContext() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();

        if (movedContraption != null)
            if (!movedContraption.method_5805())
                movedContraption = null;

        if (isPassive())
            return;

        if (field_11863.field_9236)
            clientOffsetDiff *= .75f;

        if (waitingForSpeedChange) {
            if (movedContraption != null) {
                if (field_11863.field_9236) {
                    float syncSpeed = clientOffsetDiff / 2f;
                    offset += syncSpeed;
                    movedContraption.setContraptionMotion(toMotionVector(syncSpeed));
                    return;
                }
                movedContraption.setContraptionMotion(class_243.field_1353);
            }
            return;
        }

        if (!field_11863.field_9236 && assembleNextTick) {
            assembleNextTick = false;
            if (running) {
                if (getSpeed() == 0)
                    tryDisassemble();
                else
                    sendData();
                return;
            } else {
                if (getSpeed() != 0)
                    try {
                        assemble();
                        lastException = null;
                    } catch (AssemblyException e) {
                        lastException = e;
                    }
                sendData();
            }
            return;
        }

        if (!running)
            return;

        boolean contraptionPresent = movedContraption != null;
        if (needsContraption && !contraptionPresent)
            return;

        float movementSpeed = getMovementSpeed();
        boolean locked = false;
        if (sequencedOffsetLimit > 0) {
            sequencedOffsetLimit = Math.max(0, sequencedOffsetLimit - Math.abs(movementSpeed));
            locked = sequencedOffsetLimit == 0;
        }
        float newOffset = offset + movementSpeed;
        if ((int) newOffset != (int) offset)
            visitNewPosition();

        if (locked) {
            forceMove = true;
            resetContraptionToOffset();
            sendData();
        }

        if (contraptionPresent) {
            if (moveAndCollideContraption()) {
                movedContraption.setContraptionMotion(class_243.field_1353);
                offset = getGridOffset(offset);
                resetContraptionToOffset();
                collided();
                return;
            }
        }

        if (!contraptionPresent || !movedContraption.isStalled())
            offset = newOffset;

        int extensionRange = getExtensionRange();
        if (offset <= 0 || offset >= extensionRange) {
            offset = offset <= 0 ? 0 : extensionRange;
            if (!field_11863.field_9236) {
                moveAndCollideContraption();
                resetContraptionToOffset();
                tryDisassemble();
                if (waitingForSpeedChange) {
                    forceMove = true;
                    sendData();
                }
            }
        }
    }

    protected boolean isPassive() {
        return false;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (movedContraption != null && !field_11863.field_9236)
            sendData();
    }

    protected int getGridOffset(float offset) {
        return class_3532.method_15340((int) (offset + .5f), 0, getExtensionRange());
    }

    public float getInterpolatedOffset(float partialTicks) {
        float interpolatedOffset = class_3532.method_15363(offset + (partialTicks - .5f) * getMovementSpeed(), 0, getExtensionRange());
        return interpolatedOffset;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        sequencedOffsetLimit = -1;

        if (isPassive())
            return;

        assembleNextTick = true;
        waitingForSpeedChange = false;

        if (movedContraption != null && Math.signum(prevSpeed) != Math.signum(getSpeed()) && prevSpeed != 0) {
            if (!movedContraption.isStalled()) {
                offset = Math.round(offset * 16) / 16;
                resetContraptionToOffset();
            }
            movedContraption.getContraption().stop(field_11863);
        }

        if (sequenceContext != null && sequenceContext.instruction() == SequencerInstructions.TURN_DISTANCE)
            sequencedOffsetLimit = sequenceContext.getEffectiveValue(getTheoreticalSpeed());
    }

    @Override
    public void remove() {
        this.field_11865 = true;
        if (!field_11863.field_9236)
            disassemble();
        super.remove();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", running);
        view.method_71472("Waiting", waitingForSpeedChange);
        view.method_71464("Offset", offset);
        if (sequencedOffsetLimit >= 0)
            view.method_71463("SequencedOffsetLimit", sequencedOffsetLimit);
        if (lastException != null) {
            view.method_71468("LastException", AssemblyException.CODEC, lastException);
        }
        super.write(view, clientPacket);

        if (clientPacket && forceMove) {
            view.method_71472("ForceMovement", forceMove);
            forceMove = false;
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean forceMovement = view.method_71433("ForceMovement", false);
        float offsetBefore = offset;

        running = view.method_71433("Running", false);
        waitingForSpeedChange = view.method_71433("Waiting", false);
        offset = view.method_71423("Offset", 0);
        sequencedOffsetLimit = view.method_71422("SequencedOffsetLimit", -1);
        lastException = view.method_71426("LastException", AssemblyException.CODEC).orElse(null);
        super.read(view, clientPacket);

        if (!clientPacket)
            return;
        if (forceMovement)
            resetContraptionToOffset();
        else if (running) {
            clientOffsetDiff = offset - offsetBefore;
            offset = offsetBefore;
        }
        if (!running)
            movedContraption = null;
    }

    public AssemblyException getLastAssemblyException() {
        return lastException;
    }

    public abstract void disassemble();

    protected abstract void assemble() throws AssemblyException;

    protected abstract int getExtensionRange();

    protected abstract int getInitialOffset();

    protected abstract class_243 toMotionVector(float speed);

    protected abstract class_243 toPosition(float offset);

    protected void visitNewPosition() {
    }

    protected void tryDisassemble() {
        if (field_11865) {
            disassemble();
            return;
        }
        if (getMovementMode() == MovementMode.MOVE_NEVER_PLACE) {
            waitingForSpeedChange = true;
            return;
        }
        int initial = getInitialOffset();
        if ((int) (offset + .5f) != initial && getMovementMode() == MovementMode.MOVE_PLACE_RETURNED) {
            waitingForSpeedChange = true;
            return;
        }
        disassemble();
    }

    protected MovementMode getMovementMode() {
        return movementMode.get();
    }

    protected boolean moveAndCollideContraption() {
        if (movedContraption == null)
            return false;
        if (movedContraption.isStalled()) {
            movedContraption.setContraptionMotion(class_243.field_1353);
            return false;
        }

        class_243 motion = getMotionVector();
        movedContraption.setContraptionMotion(getMotionVector());
        movedContraption.move(motion.field_1352, motion.field_1351, motion.field_1350);
        return ContraptionCollider.collideBlocks(movedContraption);
    }

    protected void collided() {
        if (field_11863.field_9236) {
            waitingForSpeedChange = true;
            return;
        }
        offset = getGridOffset(offset - getMovementSpeed());
        resetContraptionToOffset();
        tryDisassemble();
    }

    protected void resetContraptionToOffset() {
        if (movedContraption == null)
            return;
        if (!movedContraption.method_5805())
            return;
        class_243 vec = toPosition(offset);
        movedContraption.method_5814(vec.field_1352, vec.field_1351, vec.field_1350);
        if (getSpeed() == 0 || waitingForSpeedChange)
            movedContraption.setContraptionMotion(class_243.field_1353);
    }

    public float getMovementSpeed() {
        float movementSpeed = class_3532.method_15363(convertToLinear(getSpeed()), -.49f, .49f) + clientOffsetDiff / 2f;
        if (field_11863.field_9236)
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        if (sequencedOffsetLimit >= 0)
            movementSpeed = (float) class_3532.method_15350(movementSpeed, -sequencedOffsetLimit, sequencedOffsetLimit);
        return movementSpeed;
    }

    public class_243 getMotionVector() {
        return toMotionVector(getMovementSpeed());
    }

    @Override
    public void onStall() {
        if (!field_11863.field_9236) {
            forceMove = true;
            sendData();
        }
    }

    public void onLengthBroken() {
        offset = 0;
        sendData();
    }

    @Override
    public boolean isValid() {
        return !method_11015();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!field_11863.field_9236) {
            this.running = true;
            sendData();
        }
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return movedContraption == contraption;
    }

    @Override
    public class_2338 getBlockPosition() {
        return field_11867;
    }
}
