package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.*;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.PistonState;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3532;

public class MechanicalPistonBlockEntity extends LinearActuatorBlockEntity {
    protected int extensionLength;

    public MechanicalPistonBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_PISTON, pos, state);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        extensionLength = view.method_71424("ExtensionLength", 0);
        super.read(view, clientPacket);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("ExtensionLength", extensionLength);
        super.write(view, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(field_11863.method_8320(field_11867).method_26204() instanceof MechanicalPistonBlock))
            return;

        class_2350 direction = method_11010().method_11654(class_2741.field_12525);

        // Collect Construct
        PistonContraption contraption = new PistonContraption(direction, getMovementSpeed() < 0);
        if (!contraption.assemble(field_11863, field_11867))
            return;

        class_2350 positive = class_2350.method_10156(class_2352.field_11056, direction.method_10166());
        class_2350 movementDirection = getSpeed() > 0 ^ direction.method_10166() != class_2351.field_11051 ? positive : positive.method_10153();

        class_2338 anchor = contraption.anchor.method_10079(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(field_11863, contraption, anchor.method_10093(movementDirection), movementDirection))
            return;

        // Check if not at limit already
        extensionLength = contraption.extensionLength;
        float resultingOffset = contraption.initialExtensionProgress + Math.signum(getMovementSpeed()) * .5f;
        if (resultingOffset <= 0 || resultingOffset >= extensionLength) {
            return;
        }

        // Run
        running = true;
        offset = contraption.initialExtensionProgress;
        sendData();
        clientOffsetDiff = 0;

        class_2338 startPos = class_2338.field_10980.method_10079(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(field_11863, startPos);
        movedContraption = ControlledContraptionEntity.create(method_10997(), this, contraption);
        resetContraptionToOffset();
        forceMove = true;
        field_11863.method_8649(movedContraption);

        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(field_11863, field_11867);

        if (contraption.containsBlockBreakers())
            award(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void disassemble() {
        if (!running && movedContraption == null)
            return;
        if (!field_11865)
            method_10997().method_8652(field_11867, method_11010().method_11657(MechanicalPistonBlock.STATE, PistonState.EXTENDED), 3 | 16);
        if (movedContraption != null) {
            resetContraptionToOffset();
            movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(field_11863, field_11867);
        }
        running = false;
        movedContraption = null;
        sendData();

        if (field_11865)
            AllBlocks.MECHANICAL_PISTON.method_9576(field_11863, field_11867, method_11010(), null);
    }

    @Override
    protected void collided() {
        super.collided();
        if (!running && getMovementSpeed() > 0)
            assembleNextTick = true;
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = class_3532.method_15363(convertToLinear(getSpeed()), -.49f, .49f);
        if (field_11863.field_9236)
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        class_2350 pistonDirection = method_11010().method_11654(class_2741.field_12525);
        int movementModifier = pistonDirection.method_10171().method_10181() * (pistonDirection.method_10166() == class_2351.field_11051 ? -1 : 1);
        movementSpeed = movementSpeed * -movementModifier + clientOffsetDiff / 2f;

        int extensionRange = getExtensionRange();
        movementSpeed = class_3532.method_15363(movementSpeed, 0 - offset, extensionRange - offset);
        if (sequencedOffsetLimit >= 0)
            movementSpeed = (float) class_3532.method_15350(movementSpeed, -sequencedOffsetLimit, sequencedOffsetLimit);
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        class_2350 pistonDirection = method_11010().method_11654(class_2741.field_12525);
        return class_243.method_24954(pistonDirection.method_62675()).method_1021(speed);
    }

    @Override
    protected class_243 toPosition(float offset) {
        class_243 position = class_243.method_24954(method_11010().method_11654(class_2741.field_12525).method_62675()).method_1021(offset);
        return position.method_1019(class_243.method_24954(movedContraption.getContraption().anchor));
    }

    @Override
    protected int getInitialOffset() {
        return movedContraption == null ? 0 : ((PistonContraption) movedContraption.getContraption()).initialExtensionProgress;
    }
}
