package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class GirderWrenchBehavior {
    @Nullable
    public static Pair<class_2350, Action> getDirectionAndAction(class_3965 result, class_1937 world, class_2338 pos) {
        List<Pair<class_2350, Action>> validDirections = getValidDirections(world, pos);

        if (validDirections.isEmpty())
            return null;

        List<class_2350> directions = IPlacementHelper.orderedByDistance(pos, result.method_17784(), validDirections.stream().map(Pair::getFirst).toList());

        if (directions.isEmpty())
            return null;

        class_2350 dir = directions.getFirst();
        return validDirections.stream().filter(pair -> pair.getFirst() == dir).findFirst().orElseGet(() -> Pair.of(dir, Action.SINGLE));
    }

    public static List<Pair<class_2350, Action>> getValidDirections(class_1922 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);

        if (!blockState.method_27852(AllBlocks.METAL_GIRDER))
            return Collections.emptyList();

        return Arrays.stream(Iterate.directions).<Pair<class_2350, Action>>mapMulti((direction, consumer) -> {
            class_2680 other = level.method_8320(pos.method_10093(direction));

            if (!blockState.method_11654(GirderBlock.X) && !blockState.method_11654(GirderBlock.Z))
                return;

            // up and down
            if (direction.method_10166() == class_2351.field_11052) {
                // no other girder in target dir
                if (!other.method_27852(AllBlocks.METAL_GIRDER)) {
                    if (!blockState.method_11654(GirderBlock.X) ^ !blockState.method_11654(GirderBlock.Z))
                        consumer.accept(Pair.of(direction, Action.SINGLE));
                    return;
                }
                // this girder is a pole or cross
                if (blockState.method_11654(GirderBlock.X) == blockState.method_11654(GirderBlock.Z))
                    return;
                // other girder is a pole or cross
                if (other.method_11654(GirderBlock.X) == other.method_11654(GirderBlock.Z))
                    return;
                // toggle up/down connection for both
                consumer.accept(Pair.of(direction, Action.PAIR));

                return;
            }

            //					if (AllBlocks.METAL_GIRDER.has(other))
            //						consumer.accept(Pair.of(direction, Action.HORIZONTAL));

        }).toList();
    }

    public static boolean handleClick(class_1937 level, class_2338 pos, class_2680 state, class_3965 result) {
        Pair<class_2350, Action> dirPair = getDirectionAndAction(result, level, pos);
        if (dirPair == null)
            return false;
        if (level.field_9236)
            return true;
        if (!state.method_11654(GirderBlock.X) && !state.method_11654(GirderBlock.Z))
            return false;

        class_2350 dir = dirPair.getFirst();

        class_2338 otherPos = pos.method_10093(dir);
        class_2680 other = level.method_8320(otherPos);

        if (dir == class_2350.field_11036) {
            level.method_8652(pos, postProcess(state.method_28493(GirderBlock.TOP)), 2 | 16);
            if (dirPair.getSecond() == Action.PAIR && other.method_27852(AllBlocks.METAL_GIRDER))
                level.method_8652(otherPos, postProcess(other.method_28493(GirderBlock.BOTTOM)), 2 | 16);
            return true;
        }

        if (dir == class_2350.field_11033) {
            level.method_8652(pos, postProcess(state.method_28493(GirderBlock.BOTTOM)), 2 | 16);
            if (dirPair.getSecond() == Action.PAIR && other.method_27852(AllBlocks.METAL_GIRDER))
                level.method_8652(otherPos, postProcess(other.method_28493(GirderBlock.TOP)), 2 | 16);
            return true;
        }

        //		if (dirPair.getSecond() == Action.HORIZONTAL) {
        //			BooleanProperty property = dir.getAxis() == Direction.Axis.X ? GirderBlock.X : GirderBlock.Z;
        //			level.setBlock(pos, state.cycle(property), 2 | 16);
        //
        //			return true;
        //		}

        return true;
    }

    private static class_2680 postProcess(class_2680 newState) {
        if (newState.method_11654(GirderBlock.TOP) && newState.method_11654(GirderBlock.BOTTOM))
            return newState;
        if (newState.method_11654(GirderBlock.AXIS) != class_2351.field_11052)
            return newState;
        return newState.method_11657(GirderBlock.AXIS, newState.method_11654(GirderBlock.X) ? class_2351.field_11048 : class_2351.field_11051);
    }

    public enum Action {
        SINGLE,
        PAIR,
        HORIZONTAL
    }
}
