package com.zurrtum.create.content.decoration.palettes;

import com.zurrtum.create.catnip.data.Iterate;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6756;

public class ConnectedPillarBlock extends LayeredBlock {

    public static final class_2746 NORTH = class_2746.method_11825("north");
    public static final class_2746 SOUTH = class_2746.method_11825("south");
    public static final class_2746 EAST = class_2746.method_11825("east");
    public static final class_2746 WEST = class_2746.method_11825("west");

    public ConnectedPillarBlock(class_2251 p_55926_) {
        super(p_55926_);
        method_9590(method_9564().method_11657(NORTH, false).method_11657(WEST, false).method_11657(EAST, false).method_11657(SOUTH, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(NORTH, SOUTH, EAST, WEST));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 state = super.method_9605(pContext);
        return updateColumn(pContext.method_8045(), pContext.method_8037(), state, true);
    }

    private class_2680 updateColumn(class_1937 level, class_2338 pos, class_2680 state, boolean present) {
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        class_2351 axis = state.method_11654(field_11459);

        for (class_2350 connection : Iterate.directions) {
            if (connection.method_10166() == axis)
                continue;

            boolean connect = true;
            Move:
            for (class_2350 movement : Iterate.directionsInAxis(axis)) {
                currentPos.method_10101(pos);
                for (int i = 0; i < 1000; i++) {
                    if (!level.method_8477(currentPos))
                        break;

                    class_2680 other1 = currentPos.equals(pos) ? state : level.method_8320(currentPos);
                    class_2680 other2 = level.method_8320(currentPos.method_10093(connection));
                    boolean col1 = canConnect(state, other1);
                    boolean col2 = canConnect(state, other2);
                    currentPos.method_10098(movement);

                    if (!col1 && !col2)
                        break;
                    if (col1 && col2)
                        continue;

                    connect = false;
                    break Move;
                }
            }
            state = setConnection(state, connection, connect);
        }
        return state;
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_26204() == this)
            return;
        class_6756<class_2248> blockTicks = pLevel.method_8397();
        if (!blockTicks.method_8674(pPos, this))
            pLevel.method_64310(pPos, this, 1);
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        if (pState.method_26204() != this)
            return;
        class_2338 belowPos = pPos.method_10093(class_2350.method_10169(pState.method_11654(field_11459), class_2352.field_11060));
        class_2680 belowState = pLevel.method_8320(belowPos);
        if (!canConnect(pState, belowState))
            pLevel.method_8652(pPos, updateColumn(pLevel, pPos, pState, true), class_2248.field_31036);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        if (!canConnect(state, pNeighborState))
            return setConnection(state, pDirection, false);
        if (pDirection.method_10166() == state.method_11654(field_11459))
            return method_34725(pNeighborState);

        return setConnection(state, pDirection, getConnection(pNeighborState, pDirection.method_10153()));
    }

    protected boolean canConnect(class_2680 state, class_2680 other) {
        return other.method_26204() == this && state.method_11654(field_11459) == other.method_11654(field_11459);
    }

    @Override
    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        if (pIsMoving)
            return;
        for (class_2350 d : Iterate.directionsInAxis(pState.method_11654(field_11459))) {
            class_2338 relative = pPos.method_10093(d);
            class_2680 adjacent = pLevel.method_8320(relative);
            if (canConnect(pState, adjacent))
                pLevel.method_8652(relative, updateColumn(pLevel, relative, adjacent, false), class_2248.field_31036);
        }
    }

    public static boolean getConnection(class_2680 state, class_2350 side) {
        class_2746 property = connection(state.method_11654(field_11459), side);
        return property != null && state.method_11654(property);
    }

    public static class_2680 setConnection(class_2680 state, class_2350 side, boolean connect) {
        class_2746 property = connection(state.method_11654(field_11459), side);
        if (property != null)
            state = state.method_11657(property, connect);
        return state;
    }

    public static class_2746 connection(class_2351 axis, class_2350 side) {
        if (side.method_10166() == axis)
            return null;

        if (axis == class_2351.field_11048) {
            return switch (side) {
                case field_11036 -> EAST;
                case field_11043 -> NORTH;
                case field_11035 -> SOUTH;
                case field_11033 -> WEST;
                default -> null;
            };
        }

        if (axis == class_2351.field_11052) {
            return switch (side) {
                case field_11034 -> EAST;
                case field_11043 -> NORTH;
                case field_11035 -> SOUTH;
                case field_11039 -> WEST;
                default -> null;
            };
        }

        if (axis == class_2351.field_11051) {
            return switch (side) {
                case field_11036 -> WEST;
                case field_11039 -> SOUTH;
                case field_11034 -> NORTH;
                case field_11033 -> EAST;
                default -> null;
            };
        }

        return null;
    }

}