package com.zurrtum.create.content.decoration.placard;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class PlacardBlock extends class_2341 implements ProperWaterloggedBlock, IBE<PlacardBlockEntity>, SpecialBlockItemRequirement, IWrenchable {

    public static final class_2746 POWERED = class_2741.field_12484;

    public static final MapCodec<PlacardBlock> field_46280 = method_54094(PlacardBlock::new);

    public PlacardBlock(class_2251 p_53182_) {
        super(p_53182_);
        method_9590(method_9564().method_11657(WATERLOGGED, false).method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(field_11007, field_11177, WATERLOGGED, POWERED));
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return canAttachLenient(pLevel, pPos, method_10119(pState).method_10153());
    }

    public static boolean canAttachLenient(class_4538 pReader, class_2338 pPos, class_2350 pDirection) {
        class_2338 blockpos = pPos.method_10093(pDirection);
        return !pReader.method_8320(blockpos).method_26220(pReader, blockpos).method_1110();
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        if (stateForPlacement == null)
            return null;
        if (stateForPlacement.method_11654(field_11007) == class_2738.field_12475)
            stateForPlacement = stateForPlacement.method_11657(field_11177, stateForPlacement.method_11654(field_11177).method_10153());
        return withWater(stateForPlacement, pContext);
    }

    @Override
    public boolean method_9506(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9524(class_2680 pBlockState, class_1922 pBlockAccess, class_2338 pPos, class_2350 pSide) {
        return pBlockState.method_11654(POWERED) ? 15 : 0;
    }

    @Override
    public int method_9603(class_2680 pBlockState, class_1922 pBlockAccess, class_2338 pPos, class_2350 pSide) {
        return pBlockState.method_11654(POWERED) && method_10119(pBlockState) == pSide ? 15 : 0;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.PLACARD.get(method_10119(pState));
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return super.method_9559(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715())
            return class_1269.field_52423;
        if (level.field_9236)
            return class_1269.field_5812;

        class_1799 inHand = player.method_5998(hand);
        return onBlockEntityUseItemOn(
            level, pos, pte -> {
                class_1799 inBlock = pte.getHeldItem();

                if (!player.method_7294() || inHand.method_7960() || !inBlock.method_7960()) {
                    if (inBlock.method_7960())
                        return class_1269.field_5814;
                    if (inHand.method_7960())
                        return class_1269.field_5814;
                    if (state.method_11654(POWERED))
                        return class_1269.field_5814;

                    boolean test = inBlock.method_7909() instanceof FilterItem ? FilterItemStack.of(inBlock)
                        .test(level, inHand) : class_1799.method_31577(inHand, inBlock);
                    if (!test) {
                        AllSoundEvents.DENY.play(level, null, pos, 1, 1);
                        return class_1269.field_5812;
                    }

                    AllSoundEvents.CONFIRM.play(level, null, pos, 1, 1);
                    level.method_8652(pos, state.method_11657(POWERED, true), class_2248.field_31036);
                    updateNeighbours(state, level, pos);
                    pte.poweredTicks = 19;
                    pte.notifyUpdate();
                    return class_1269.field_5812;
                }

                level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1, 1);
                pte.setHeldItem(inHand.method_46651(1));

                if (!player.method_68878()) {
                    inHand.method_7934(1);
                    if (inHand.method_7960())
                        player.method_6122(hand, class_1799.field_8037);
                }

                return class_1269.field_5812;
            }
        );
    }

    public static class_2350 connectedDirection(class_2680 state) {
        return method_10119(state);
    }

    @Override
    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        if (!pIsMoving && pState.method_11654(POWERED))
            updateNeighbours(pState, pLevel, pPos);
    }

    public static void updateNeighbours(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        pLevel.method_8452(pPos, pState.method_26204(), null);
        pLevel.method_8452(pPos.method_10093(method_10119(pState).method_10153()), pState.method_26204(), null);
    }

    @Override
    public void method_9606(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer) {
        if (pLevel.field_9236)
            return;
        withBlockEntityDo(
            pLevel, pPos, pte -> {
                class_1799 heldItem = pte.getHeldItem();
                if (heldItem.method_7960())
                    return;
                pPlayer.method_31548().method_7398(heldItem);
                pLevel.method_8396(null, pPos, class_3417.field_14770, class_3419.field_15245, 1, 1);
                pte.setHeldItem(class_1799.field_8037);
            }
        );
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        class_1799 placardStack = AllItems.PLACARD.method_7854();
        if (be instanceof PlacardBlockEntity pbe) {
            class_1799 heldItem = pbe.getHeldItem();
            if (!heldItem.method_7960()) {
                return new ItemRequirement(List.of(
                    new ItemRequirement.StackRequirement(placardStack, ItemUseType.CONSUME),
                    new ItemRequirement.StrictNbtStackRequirement(heldItem, ItemUseType.CONSUME)
                ));
            }
        }
        return new ItemRequirement(ItemUseType.CONSUME, placardStack);
    }

    @Override
    public Class<PlacardBlockEntity> getBlockEntityClass() {
        return PlacardBlockEntity.class;
    }

    @Override
    public class_2591<? extends PlacardBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PLACARD;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2341> method_53969() {
        return field_46280;
    }

}
