package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class WhistleExtenderBlock extends class_2248 implements IWrenchable {

    public static final class_2754<WhistleExtenderShape> SHAPE = class_2754.method_11850("shape", WhistleExtenderShape.class);
    public static final class_2754<WhistleSize> SIZE = WhistleBlock.SIZE;

    public enum WhistleExtenderShape implements class_3542 {
        SINGLE,
        DOUBLE,
        DOUBLE_CONNECTED;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public WhistleExtenderBlock(class_2251 p_49795_) {
        super(p_49795_);
        method_9590(method_9564().method_11657(SHAPE, WhistleExtenderShape.SINGLE).method_11657(SIZE, WhistleSize.MEDIUM));
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();

        if (context.method_17698().field_1351 < context.method_8037().method_10264() + .5f || state.method_11654(SHAPE) == WhistleExtenderShape.SINGLE)
            return IWrenchable.super.onSneakWrenched(state, context);
        if (!(world instanceof class_3218))
            return class_1269.field_5812;
        world.method_8652(pos, state.method_11657(SHAPE, WhistleExtenderShape.SINGLE), class_2248.field_31036);
        IWrenchable.playRemoveSound(world, pos);
        return class_1269.field_5812;
    }

    protected class_1838 relocateContext(class_1838 context, class_2338 target) {
        return new class_1838(
            context.method_8036(),
            context.method_20287(),
            new class_3965(context.method_17698(), context.method_8038(), target, context.method_17699())
        );
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null || !stack.method_31574(AllItems.STEAM_WHISTLE))
            return class_1269.field_52423;
        class_2338 findRoot = findRoot(level, pos);
        class_2680 blockState = level.method_8320(findRoot);
        if (blockState.method_26204() instanceof WhistleBlock whistle)
            return whistle.method_55765(
                stack,
                blockState,
                level,
                findRoot,
                player,
                hand,
                new class_3965(hitResult.method_17784(), hitResult.method_17780(), findRoot, hitResult.method_17781())
            );
        return class_1269.field_52423;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 findRoot = findRoot(level, context.method_8037());
        class_2680 blockState = level.method_8320(findRoot);
        if (blockState.method_26204() instanceof WhistleBlock whistle)
            return whistle.onWrenched(blockState, relocateContext(context, findRoot));
        return IWrenchable.super.onWrenched(state, context);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.STEAM_WHISTLE.method_7854();
    }

    public static class_2338 findRoot(class_1936 pLevel, class_2338 pPos) {
        class_2338 currentPos = pPos.method_10074();
        while (true) {
            class_2680 blockState = pLevel.method_8320(currentPos);
            if (blockState.method_27852(AllBlocks.STEAM_WHISTLE_EXTENSION)) {
                currentPos = currentPos.method_10074();
                continue;
            }
            return currentPos;
        }
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        class_2680 below = pLevel.method_8320(pPos.method_10074());
        return below.method_27852(this) && below.method_11654(SHAPE) != WhistleExtenderShape.SINGLE || below.method_27852(AllBlocks.STEAM_WHISTLE);
    }

    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        if (pFacing.method_10166() != class_2351.field_11052)
            return pState;

        if (pFacing == class_2350.field_11036) {
            boolean connected = pState.method_11654(SHAPE) == WhistleExtenderShape.DOUBLE_CONNECTED;
            boolean shouldConnect = pLevel.method_8320(pCurrentPos.method_10084()).method_27852(this);
            if (!connected && shouldConnect)
                return pState.method_11657(SHAPE, WhistleExtenderShape.DOUBLE_CONNECTED);
            if (connected && !shouldConnect)
                return pState.method_11657(SHAPE, WhistleExtenderShape.DOUBLE);
            return pState;
        }

        return !pState.method_26184(pLevel, pCurrentPos) ? class_2246.field_10124.method_9564() : pState.method_11657(
            SIZE,
            pLevel.method_8320(pCurrentPos.method_10074()).method_11654(SIZE)
        );
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_26204() != this || pOldState.method_11654(SHAPE) != pState.method_11654(SHAPE))
            WhistleBlock.queuePitchUpdate(pLevel, findRoot(pLevel, pPos));
    }

    @Override
    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        WhistleBlock.queuePitchUpdate(pLevel, findRoot(pLevel, pPos));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(SHAPE, SIZE));
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        WhistleSize size = pState.method_11654(SIZE);
        return switch (pState.method_11654(SHAPE)) {
            case DOUBLE ->
                size == WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE : size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE : AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE;
            case DOUBLE_CONNECTED ->
                size == WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE_CONNECTED : size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE_CONNECTED : AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE_CONNECTED;
            default ->
                size == WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE : size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM : AllShapes.WHISTLE_EXTENDER_SMALL;
        };
    }

    //TODO
    //    @Override
    //    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState,
    //        Direction dir) {
    //        return AllBlocks.STEAM_WHISTLE.has(neighborState) && dir == Direction.DOWN;
    //    }
}
