package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class AbstractBellBlockEntity extends SmartBlockEntity {

    public static final int RING_DURATION = 74;

    public boolean isRinging;
    public int ringingTicks;
    public class_2350 ringDirection;

    public AbstractBellBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public boolean ring(class_1937 world, class_2338 pos, class_2350 direction) {
        isRinging = true;
        ringingTicks = 0;
        ringDirection = direction;
        sendData();
        return true;
    }

    ;

    @Override
    public void tick() {
        super.tick();

        if (isRinging) {
            ++ringingTicks;
        }

        if (ringingTicks >= RING_DURATION) {
            isRinging = false;
            ringingTicks = 0;
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (!clientPacket || ringingTicks != 0 || !isRinging)
            return;
        view.method_71468("Ringing", class_2350.field_29502, ringDirection);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket)
            return;
        view.method_71426("Ringing", class_2350.field_29502).ifPresent(direction -> {
            ringDirection = direction;
            ringingTicks = 0;
            isRinging = true;
        });
    }
}
