package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class HauntedBellBlock extends AbstractBellBlock<HauntedBellBlockEntity> {

    public HauntedBellBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2591<? extends HauntedBellBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.HAUNTED_BELL;
    }

    @Override
    protected boolean ring(class_1937 world, class_2338 pos, class_2350 direction, class_1657 player) {
        boolean ring = super.ring(world, pos, direction, player);
        if (ring && player instanceof class_3222 serverPlayer)
            AllAdvancements.HAUNTED_BELL.trigger(serverPlayer);
        return ring;
    }

    @Override
    public Class<HauntedBellBlockEntity> getBlockEntityClass() {
        return HauntedBellBlockEntity.class;
    }

    @Override
    public void playSound(class_1937 world, class_2338 pos) {
        AllSoundEvents.HAUNTED_BELL_USE.playOnServer(world, pos, 4f, 1f);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (oldState.method_26204() != this && !world.field_9236)
            withBlockEntityDo(
                world, pos, hbte -> {
                    hbte.effectTicks = HauntedBellBlockEntity.EFFECT_TICKS;
                    hbte.sendData();
                }
            );
    }

}
