package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.equipment.wrench.IWrenchableWithBracket;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2465;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class AxisPipeBlock extends class_2465 implements IWrenchableWithBracket, IAxisPipe, NeighborUpdateListeningBlock {

    public AxisPipeBlock(class_2251 p_i48339_1_) {
        super(p_i48339_1_);
    }

    @Override
    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean isMoving) {
        FluidPropagator.propagateChangedPipe(world, pos, state);
        if (!isMoving)
            removeBracket(world, pos, true).ifPresent(stack -> class_2248.method_9577(world, pos, stack));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!stack.method_31574(AllItems.COPPER_CASING))
            return class_1269.field_52423;
        if (level.field_9236)
            return class_1269.field_5812;
        class_2680 newState = AllBlocks.ENCASED_FLUID_PIPE.method_9564();
        for (class_2350 d : Iterate.directionsInAxis(getAxis(state)))
            newState = newState.method_11657(EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), true);
        FluidTransportBehaviour.cacheFlows(level, pos);
        level.method_8501(pos, newState);
        FluidTransportBehaviour.loadFlows(level, pos);
        return class_1269.field_5812;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (world.field_9236)
            return;
        if (state != oldState)
            world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.FLUID_PIPE.method_7854();
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 otherBlock, class_2338 neighborPos, boolean isMoving) {
        class_2350 d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null)
            return;
        if (!isOpenAt(state, d))
            return;
        world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_2248 otherBlock,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        class_4209.method_19472(world, pos);
    }

    public static boolean isOpenAt(class_2680 state, class_2350 d) {
        return d.method_10166() == state.method_11654(field_11459);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 r) {
        FluidPropagator.propagateChangedPipe(world, pos, state);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get(state.method_11654(field_11459));
    }

    public class_2680 toRegularPipe(class_1936 world, class_2338 pos, class_2680 state) {
        class_2350 side = class_2350.method_10156(class_2352.field_11056, state.method_11654(field_11459));
        Map<class_2350, class_2746> facingToPropertyMap = FluidPipeBlock.field_11329;
        return AllBlocks.FLUID_PIPE.updateBlockState(
            AllBlocks.FLUID_PIPE.method_9564().method_11657(facingToPropertyMap.get(side), true).method_11657(facingToPropertyMap.get(side.method_10153()), true),
            side,
            null,
            world,
            pos
        );
    }

    @Override
    public class_2351 getAxis(class_2680 state) {
        return state.method_11654(field_11459);
    }

    @Override
    public Optional<class_1799> removeBracket(class_1922 world, class_2338 pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null)
            return Optional.empty();
        class_2680 bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null)
            return Optional.empty();
        return Optional.of(new class_1799(bracket.method_26204()));
    }

}
