package com.zurrtum.create.content.fluids.spout;

import com.zurrtum.create.*;
import com.zurrtum.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour.ProcessingResult;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

import static com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour.ProcessingResult.HOLD;
import static com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour.ProcessingResult.PASS;

public class SpoutBlockEntity extends SmartBlockEntity {

    public static final int FILLING_TIME = 20;
    protected BeltProcessingBehaviour beltProcessing;

    public int processingTicks;
    public boolean sendSplash;
    public BlockSpoutingBehaviour customProcess;

    public SmartFluidTankBehaviour tank;

    private boolean createdSweetRoll, createdHoneyApple, createdChocolateBerries;

    public SpoutBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SPOUT, pos, state);
        processingTicks = -1;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0, -2, 0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        tank = SmartFluidTankBehaviour.single(this, BucketFluidInventory.CAPACITY, SpoutFluidHandler::new);
        behaviours.add(tank);

        beltProcessing = new BeltProcessingBehaviour(this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add(beltProcessing);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SPOUT, AllAdvancements.FOODS);
    }

    protected ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual())
            return PASS;
        if (!FillingBySpout.canItemBeFilled(field_11863, transported.stack))
            return PASS;
        if (tank.isEmpty())
            return HOLD;
        if (FillingBySpout.getRequiredAmountForItem((class_3218) field_11863, transported.stack, getCurrentFluidInTank()) == -1)
            return PASS;
        return HOLD;
    }

    protected ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (processingTicks != -1 && processingTicks != 5)
            return HOLD;
        if (!FillingBySpout.canItemBeFilled(field_11863, transported.stack))
            return PASS;
        if (tank.isEmpty())
            return HOLD;
        FluidStack fluid = getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem((class_3218) field_11863, transported.stack, fluid.copy());
        if (requiredAmountForItem <= 0)
            return PASS;
        if (requiredAmountForItem > fluid.getAmount())
            return HOLD;

        if (processingTicks == -1) {
            processingTicks = FILLING_TIME;
            notifyUpdate();
            AllSoundEvents.SPOUTING.playOnServer(field_11863, field_11867, 0.75f, 0.9f + 0.2f * (float) Math.random());
            return HOLD;
        }

        // Process finished
        class_1799 out = FillingBySpout.fillItem((class_3218) field_11863, requiredAmountForItem, transported.stack, fluid);
        if (!out.method_7960()) {
            transported.clearFanProcessingData();
            List<TransportedItemStack> outList = new ArrayList<>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.method_7960())
                held = transported.copy();
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, held));
        }

        award(AllAdvancements.SPOUT);
        if (trackFoods()) {
            createdChocolateBerries |= out.method_31574(AllItems.CHOCOLATE_BERRIES);
            createdHoneyApple |= out.method_31574(AllItems.HONEYED_APPLE);
            createdSweetRoll |= out.method_31574(AllItems.SWEET_ROLL);
            if (createdChocolateBerries && createdHoneyApple && createdSweetRoll)
                award(AllAdvancements.FOODS);
        }

        SmartFluidTankBehaviour.TankSegment primaryHandler = tank.getPrimaryHandler();
        primaryHandler.setFluid(fluid);
        primaryHandler.markDirty();
        sendSplash = true;
        notifyUpdate();
        return HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return tank.getPrimaryHandler().getFluid();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);

        view.method_71465("ProcessingTicks", processingTicks);
        if (sendSplash && clientPacket) {
            view.method_71472("Splash", true);
            sendSplash = false;
        }

        if (!trackFoods())
            return;
        if (createdChocolateBerries)
            view.method_71472("ChocolateBerries", true);
        if (createdHoneyApple)
            view.method_71472("HoneyApple", true);
        if (createdSweetRoll)
            view.method_71472("SweetRoll", true);
    }

    private boolean trackFoods() {
        AdvancementBehaviour behaviour = getBehaviour(AdvancementBehaviour.TYPE);
        return behaviour != null && behaviour.isOwnerPresent();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        processingTicks = view.method_71424("ProcessingTicks", 0);

        createdChocolateBerries = view.method_71433("ChocolateBerries", false);
        createdHoneyApple = view.method_71433("HoneyApple", false);
        createdSweetRoll = view.method_71433("SweetRoll", false);

        if (!clientPacket)
            return;
        if (view.method_71433("Splash", false))
            spawnSplash(tank.getPrimaryTank().getRenderedFluid());
    }

    public void tick() {
        super.tick();

        FluidStack currentFluidInTank = getCurrentFluidInTank();
        if (processingTicks == -1 && (isVirtual() || !field_11863.method_8608()) && !currentFluidInTank.isEmpty()) {
            class_2338 filling = field_11867.method_10087(2);
            BlockSpoutingBehaviour behavior = BlockSpoutingBehaviour.get(field_11863, filling);
            if (behavior != null && behavior.fillBlock(field_11863, filling, this, currentFluidInTank.copy(), true) > 0) {
                processingTicks = FILLING_TIME;
                customProcess = behavior;
                notifyUpdate();
            }
        }

        if (processingTicks >= 0) {
            processingTicks--;
            if (processingTicks == 5 && customProcess != null) {
                int fillBlock = customProcess.fillBlock(field_11863, field_11867.method_10087(2), this, currentFluidInTank.copy(), false);
                customProcess = null;
                if (fillBlock > 0) {
                    tank.getPrimaryHandler()
                        .setFluid(FluidHelper.copyStackWithAmount(currentFluidInTank, currentFluidInTank.getAmount() - fillBlock));
                    sendSplash = true;
                    notifyUpdate();
                }
            }
        }

        if (processingTicks >= 8 && field_11863.field_9236) {
            spawnProcessingParticles(tank.getPrimaryTank().getRenderedFluid());
        }
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        if (isVirtual() || fluid.isEmpty())
            return;
        class_243 vec = VecHelper.getCenterOf(field_11867);
        vec = vec.method_1023(0, 8 / 16f, 0);
        class_2394 particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        field_11863.method_8494(particle, vec.field_1352, vec.field_1351, vec.field_1350, 0, -.1f, 0);
    }

    protected static int SPLASH_PARTICLE_COUNT = 20;

    protected void spawnSplash(FluidStack fluid) {
        if (isVirtual() || fluid.isEmpty())
            return;
        class_243 vec = VecHelper.getCenterOf(field_11867);
        vec = vec.method_1023(0, 2 - 5 / 16f, 0);
        class_2394 particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; i++) {
            class_243 m = VecHelper.offsetRandomly(class_243.field_1353, field_11863.field_9229, 0.125f);
            m = new class_243(m.field_1352, Math.abs(m.field_1351), m.field_1350);
            field_11863.method_8494(particle, vec.field_1352, vec.field_1351, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public static class SpoutFluidHandler extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        public SpoutFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable class_2350 side) {
            if (side == class_2350.field_11033) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}
