package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.boiler.BoilerHeater;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import joptsimple.internal.Strings;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;

public class BoilerData {

    static final int SAMPLE_RATE = 5;

    public static final int waterSupplyPerLevel = 10 * 81;
    private static final float passiveEngineEfficiency = 1 / 8f;

    // pooled water supply
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;

    // heat score
    public boolean needsHeatLevelUpdate;
    public boolean passiveHeat;
    public int activeHeat;

    public float waterSupply;
    public int attachedEngines;
    public int attachedWhistles;

    // display
    public int maxHeatForSize = 0;
    public int maxHeatForWater = 0;
    public int minValue = 0;
    public int maxValue = 0;
    public boolean[] occludedDirections = {true, true, true, true};

    public LerpedFloat gauge = LerpedFloat.linear();

    // client only sound control

    // re-use the same lambda for each side
    private final SoundPool.Sound sound = (level, pos) -> {
        float volume = 3f / Math.max(2, attachedEngines / 6);
        float pitch = 1.18f - level.field_9229.method_43057() * .25f;
        level.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), class_3417.field_26955, class_3419.field_15245, volume, pitch, false);

        AllSoundEvents.STEAM.playAt(level, pos, volume / 16, .8f, false);
    };
    // separate pools for each side so they sound distinct when standing at corners of the boiler
    private final EnumMap<class_2350, SoundPool> pools = new EnumMap<>(class_2350.class);

    public void tick(FluidTankBlockEntity controller) {
        if (!isActive())
            return;
        class_1937 level = controller.method_10997();
        if (level.field_9236) {
            pools.values().forEach(p -> p.play(level));
            gauge.tickChaser();
            float current = gauge.getValue(1);
            if (current > 1 && level.field_9229.method_43057() < 1 / 2f)
                gauge.setValueNoUpdate(current + Math.min(-(current - 1) * level.field_9229.method_43057(), 0));
            return;
        }
        if (needsHeatLevelUpdate && updateTemperature(controller))
            controller.notifyUpdate();
        ticksUntilNextSample--;
        if (ticksUntilNextSample > 0)
            return;
        int capacity = controller.tankInventory.getMaxAmountPerStack();
        if (capacity == 0)
            return;

        ticksUntilNextSample = SAMPLE_RATE;
        supplyOverTime[currentIndex] = gatheredSupply / (float) SAMPLE_RATE;
        waterSupply = Math.max(waterSupply, supplyOverTime[currentIndex]);
        currentIndex = (currentIndex + 1) % supplyOverTime.length;
        gatheredSupply = 0;

        if (currentIndex == 0) {
            waterSupply = 0;
            for (float i : supplyOverTime)
                waterSupply = Math.max(i, waterSupply);
        }

        if (controller instanceof CreativeFluidTankBlockEntity)
            waterSupply = waterSupplyPerLevel * 20;

        if (getActualHeat(controller.getTotalTankSize()) == 18)
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);

        controller.notifyUpdate();
    }

    public void updateOcclusion(FluidTankBlockEntity controller) {
        if (!controller.method_10997().field_9236)
            return;
        if (attachedEngines + attachedWhistles == 0)
            return;
        for (class_2350 d : Iterate.horizontalDirections) {
            class_238 aabb = new class_238(controller.method_11016()).method_989(controller.width / 2f - .5f, 0, controller.width / 2f - .5f).method_1011(5f / 8);
            aabb = aabb.method_989(d.method_10148() * (controller.width / 2f + 1 / 4f), 0, d.method_10165() * (controller.width / 2f + 1 / 4f));
            aabb = aabb.method_1009(Math.abs(d.method_10165()) / 2f, 0.25f, Math.abs(d.method_10148()) / 2f);
            occludedDirections[d.method_10161()] = !controller.method_10997().method_18026(aabb);
        }
    }

    public void queueSoundOnSide(class_2338 pos, class_2350 side) {
        SoundPool pool = pools.get(side);
        if (pool == null) {
            pool = new SoundPool(4, 2, sound);
            pools.put(side, pool);
        }
        pool.queueAt(pos);
    }

    public int getTheoreticalHeatLevel() {
        return activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int boilerSize) {
        return (int) Math.min(18, boilerSize / 4);
    }

    public int getMaxHeatLevelForWaterSupply() {
        return (int) Math.min(18, class_3532.method_15386(waterSupply) / waterSupplyPerLevel);
    }

    public boolean isPassive() {
        return passiveHeat && maxHeatForSize > 0 && maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        calcMinMaxForSize(boilerSize);
        return isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (isPassive(boilerSize))
            return passiveEngineEfficiency / attachedEngines;
        if (activeHeat == 0)
            return 0;
        int actualHeat = getActualHeat(boilerSize);
        return attachedEngines <= actualHeat ? 1 : (float) actualHeat / attachedEngines;
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(activeHeat, Math.min(forWaterSupply, forBoilerSize));
        return actualHeat;
    }

    public void calcMinMaxForSize(int boilerSize) {
        maxHeatForSize = getMaxHeatLevelForBoilerSize(boilerSize);
        maxHeatForWater = getMaxHeatLevelForWaterSupply();

        minValue = Math.min(passiveHeat ? 1 : activeHeat, Math.min(maxHeatForWater, maxHeatForSize));
        maxValue = Math.max(passiveHeat ? 1 : activeHeat, Math.max(maxHeatForWater, maxHeatForSize));
    }

    @NotNull
    public class_5250 getHeatLevelTextComponent() {
        int boilerLevel = Math.min(activeHeat, Math.min(maxHeatForWater, maxHeatForSize));

        return isPassive() ? class_2561.method_43471("create.boiler.passive") : (boilerLevel == 0 ? class_2561.method_43471("create.boiler.idle") : boilerLevel == 18 ? class_2561.method_43471(
            "create.boiler.max_lvl") : class_2561.method_43469("create.boiler.lvl", String.valueOf(boilerLevel)));
    }

    public class_5250 getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, class_124... styles) {
        return componentHelper("size", maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, class_124... styles) {
        return componentHelper("water", maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, class_124... styles) {
        return componentHelper("heat", passiveHeat ? 1 : activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private class_5250 componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, class_124... styles) {
        class_5250 base = useBlocksAsBars ? blockComponent(level) : barComponent(level);

        if (!forGoggles)
            return base;

        class_124 style1 = styles.length >= 1 ? styles[0] : class_124.field_1080;
        class_124 style2 = styles.length >= 2 ? styles[1] : class_124.field_1063;

        return class_2561.method_43471("create.boiler." + label).method_27692(style1)
            .method_10852(class_2561.method_43471("create.boiler." + label + "_dots").method_27692(style2)).method_10852(base);
    }

    private class_5250 blockComponent(int level) {
        return class_2561.method_43470("█".repeat(minValue) + "▒".repeat(level - minValue) + "░".repeat(maxValue - level));
    }

    private class_5250 barComponent(int level) {
        return class_2561.method_43473().method_10852(bars(Math.max(0, minValue - 1), class_124.field_1077)).method_10852(bars(minValue > 0 ? 1 : 0, class_124.field_1060))
            .method_10852(bars(Math.max(0, level - minValue), class_124.field_1077)).method_10852(bars(Math.max(0, maxValue - level), class_124.field_1079))
            .method_10852(bars(Math.max(0, Math.min(18 - maxValue, ((maxValue / 5 + 1) * 5) - maxValue)), class_124.field_1063));
    }

    private class_5250 bars(int level, class_124 format) {
        return class_2561.method_43470(Strings.repeat('|', level)).method_27692(format);
    }

    public boolean evaluate(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        int prevEngines = attachedEngines;
        int prevWhistles = attachedWhistles;
        attachedEngines = 0;
        attachedWhistles = 0;

        for (int yOffset = 0; yOffset < controller.height; yOffset++) {
            for (int xOffset = 0; xOffset < controller.width; xOffset++) {
                for (int zOffset = 0; zOffset < controller.width; zOffset++) {

                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState))
                        continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (attachedState.method_27852(AllBlocks.STEAM_ENGINE) && SteamEngineBlock.getFacing(attachedState) == d)
                            attachedEngines++;
                        if (attachedState.method_27852(AllBlocks.STEAM_WHISTLE) && WhistleBlock.getAttachedDirection(attachedState).method_10153() == d)
                            attachedWhistles++;
                    }
                }
            }
        }

        needsHeatLevelUpdate = true;
        return prevEngines != attachedEngines || prevWhistles != attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankBlockEntity controller) {
        AdvancementBehaviour behaviour = controller.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour == null || !behaviour.isOwnerPresent())
            return;

        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        Set<Integer> whistlePitches = new HashSet<>();

        for (int yOffset = 0; yOffset < controller.height; yOffset++) {
            for (int xOffset = 0; xOffset < controller.width; xOffset++) {
                for (int zOffset = 0; zOffset < controller.width; zOffset++) {

                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState))
                        continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (attachedState.method_27852(AllBlocks.STEAM_WHISTLE) && WhistleBlock.getAttachedDirection(attachedState).method_10153() == d) {
                            if (level.method_8321(attachedPos) instanceof WhistleBlockEntity wbe)
                                whistlePitches.add(wbe.getPitchId());
                        }
                    }
                }
            }
        }

        if (whistlePitches.size() >= 12)
            controller.award(AllAdvancements.PIPE_ORGAN);
    }

    public boolean updateTemperature(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        needsHeatLevelUpdate = false;

        boolean prevPassive = passiveHeat;
        int prevActive = activeHeat;
        passiveHeat = false;
        activeHeat = 0;

        for (int xOffset = 0; xOffset < controller.width; xOffset++) {
            for (int zOffset = 0; zOffset < controller.width; zOffset++) {
                class_2338 pos = controllerPos.method_10069(xOffset, -1, zOffset);
                class_2680 blockState = level.method_8320(pos);
                float heat = BoilerHeater.findHeat(level, pos, blockState);
                if (heat == 0) {
                    passiveHeat = true;
                } else if (heat > 0) {
                    activeHeat += heat;
                }
            }
        }

        passiveHeat &= activeHeat == 0;

        return prevActive != activeHeat || prevPassive != passiveHeat;
    }

    public boolean isActive() {
        return attachedEngines > 0 || attachedWhistles > 0;
    }

    public void clear() {
        waterSupply = 0;
        activeHeat = 0;
        passiveHeat = false;
        attachedEngines = 0;
        Arrays.fill(supplyOverTime, 0);
    }

    public void write(class_11372 view) {
        view.method_71464("Supply", waterSupply);
        view.method_71465("ActiveHeat", activeHeat);
        view.method_71472("PassiveHeat", passiveHeat);
        view.method_71465("Engines", attachedEngines);
        view.method_71465("Whistles", attachedWhistles);
        view.method_71472("Update", needsHeatLevelUpdate);
    }

    public void read(class_11368 view, int boilerSize) {
        waterSupply = view.method_71423("Supply", 0);
        activeHeat = view.method_71424("ActiveHeat", 0);
        passiveHeat = view.method_71433("PassiveHeat", false);
        attachedEngines = view.method_71424("Engines", 0);
        attachedWhistles = view.method_71424("Whistles", 0);
        needsHeatLevelUpdate = view.method_71433("Update", false);
        Arrays.fill(supplyOverTime, (int) waterSupply);

        int forBoilerSize = getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = isPassive(boilerSize) ? 1 / 8f : forBoilerSize == 0 ? 0 : actualHeat / (forBoilerSize * 1f);
        gauge.chase(target, 0.125f, Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler implements FluidInventory {
        private int fill;

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FluidStack getStack(int slot) {
            return FluidStack.EMPTY;
        }

        @Override
        public int getMaxAmountPerStack() {
            return 10 * BucketFluidInventory.CAPACITY;
        }

        @Override
        public void markDirty() {
            if (fill > 0) {
                gatheredSupply += fill;
                fill = 0;
            }
        }

        @Override
        public boolean isValid(int slot, FluidStack stack) {
            return FluidHelper.isWater(stack.getFluid());
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            fill += stack.getAmount();
        }
    }

}
