package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.tank.CreativeFluidTankBlockEntity.CreativeFluidTankInventory;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.blockEntity.ComparatorUtil;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.fluid.FluidHelper.FluidExchange;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.util.*;
import java.util.Locale;

public class FluidTankBlock extends class_2248 implements IWrenchable, IBE<FluidTankBlockEntity>, FluidInventoryProvider<FluidTankBlockEntity> {
    public static final class_2746 TOP = class_2746.method_11825("top");
    public static final class_2746 BOTTOM = class_2746.method_11825("bottom");
    public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);
    public static final class_2758 LIGHT_LEVEL = class_2741.field_12538;

    private boolean creative;

    public static FluidTankBlock regular(class_2251 p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, false);
    }

    public static FluidTankBlock creative(class_2251 p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, true);
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    protected FluidTankBlock(class_2251 p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        method_9590(method_9564().method_11657(TOP, true).method_11657(BOTTOM, true).method_11657(SHAPE, Shape.WINDOW).method_11657(LIGHT_LEVEL, 0));
    }

    public static boolean isTank(class_2680 state) {
        return state.method_26204() instanceof FluidTankBlock;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        if (oldState.method_26204() == state.method_26204())
            return;
        if (moved)
            return;
        withBlockEntityDo(world, pos, FluidTankBlockEntity::updateConnectivity);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        p_206840_1_.method_11667(TOP, BOTTOM, SHAPE, LIGHT_LEVEL);
    }

    public static int getLight(class_2680 state) {
        return state.method_11654(LIGHT_LEVEL);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        withBlockEntityDo(context.method_8045(), context.method_8037(), FluidTankBlockEntity::toggleWindows);
        return class_1269.field_5812;
    }

    static final class_265 CAMPFIRE_SMOKE_CLIP = class_2248.method_9541(0, 4, 0, 16, 16, 16);

    @Override
    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        if (pContext == class_3726.method_16194())
            return CAMPFIRE_SMOKE_CLIP;
        return pState.method_26218(pLevel, pPos);
    }

    @Override
    public class_265 method_25959(class_2680 pState, class_1922 pReader, class_2338 pPos) {
        return class_259.method_1077();
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        if (pDirection == class_2350.field_11033 && pNeighborState.method_26204() != this)
            withBlockEntityDo(pLevel, pCurrentPos, FluidTankBlockEntity::updateBoilerTemperature);
        return pState;
    }

    @Override
    public FluidInventory getFluidInventory(class_1936 world, class_2338 pos, class_2680 state, FluidTankBlockEntity blockEntity, class_2350 context) {
        if (blockEntity.fluidCapability == null) {
            blockEntity.refreshCapability();
        }
        return blockEntity.fluidCapability;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        boolean onClient = level.field_9236;

        if (stack.method_7960())
            return class_1269.field_52423;
        if (!player.method_68878() && !creative)
            return class_1269.field_52423;

        FluidExchange exchange = null;
        FluidTankBlockEntity be = ConnectivityHandler.partAt(getBlockEntityType(), level, pos);
        if (be == null)
            return class_1269.field_5814;

        if (!(state.method_26204() instanceof FluidInventoryProvider<?> provider)) {
            return class_1269.field_52423;
        }
        FluidInventory tankCapability = provider.getFluidInventory(state, level, pos, be, null);
        if (tankCapability == null)
            return class_1269.field_52423;
        FluidStack prevFluidInTank = tankCapability.getStack(0).copy();

        if (FluidHelper.tryEmptyItemIntoBE(level, player, hand, stack, be))
            exchange = FluidExchange.ITEM_TO_TANK;
        else if (FluidHelper.tryFillItemFromBE(level, player, hand, stack, be))
            exchange = FluidExchange.TANK_TO_ITEM;

        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied(level, stack) || GenericItemFilling.canItemBeFilled(level, stack))
                return class_1269.field_5812;
            return class_1269.field_52423;
        }

        class_3414 soundevent = null;
        class_2680 fluidState = null;
        FluidStack fluidInTank = tankCapability.getStack(0);

        if (exchange == FluidExchange.ITEM_TO_TANK) {
            if (creative && !onClient) {
                FluidStack fluidInItem = GenericItemEmptying.emptyItem(level, stack, true).getFirst();
                if (!fluidInItem.isEmpty() && tankCapability instanceof CreativeFluidTankInventory) {
                    tankCapability.setStack(0, fluidInItem);
                    tankCapability.markDirty();
                }
            }

            class_3611 fluid = fluidInTank.getFluid();
            fluidState = fluid.method_15785().method_15759();
            soundevent = FluidHelper.getEmptySound(fluidInTank);
        }

        if (exchange == FluidExchange.TANK_TO_ITEM) {
            if (creative && !onClient)
                if (tankCapability instanceof CreativeFluidTankInventory)
                    tankCapability.setStack(0, FluidStack.EMPTY);

            class_3611 fluid = prevFluidInTank.getFluid();
            fluidState = fluid.method_15785().method_15759();
            soundevent = FluidHelper.getFillSound(prevFluidInTank);
        }

        if (soundevent != null && !onClient) {
            float pitch = class_3532.method_15363(1 - (1f * fluidInTank.getAmount() / (FluidTankBlockEntity.getCapacityMultiplier() * 16)), 0, 1);
            pitch /= 1.5f;
            pitch += .5f;
            pitch += (level.field_9229.method_43057() - .5f) / 4f;
            level.method_8396(null, pos, soundevent, class_3419.field_15245, .5f, pitch);
        }

        if (!FluidStack.areFluidsAndComponentsEqual(fluidInTank, prevFluidInTank)) {
            FluidTankBlockEntity controllerBE = be.getControllerBE();
            if (controllerBE != null) {
                if (fluidState != null && onClient) {
                    class_2388 blockParticleData = new class_2388(class_2398.field_11217, fluidState);
                    float fluidLevel = (float) fluidInTank.getAmount() / tankCapability.getMaxAmountPerStack();

                    //TODO
                    //                    boolean reversed = fluidInTank.getFluid()
                    //                        .getFluidType()
                    //                        .isLighterThanAir();
                    if (false/*reversed*/)
                        fluidLevel = 1 - fluidLevel;

                    class_243 vec = hitResult.method_17784();
                    vec = new class_243(vec.field_1352, controllerBE.method_11016().method_10264() + fluidLevel * (controllerBE.height - .5f) + .25f, vec.field_1350);
                    class_243 motion = player.method_19538().method_1020(vec).method_1021(1 / 20f);
                    vec = vec.method_1019(motion);
                    level.method_8406(blockParticleData, vec.field_1352, vec.field_1351, vec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                    return class_1269.field_5812;
                }

                controllerBE.sendDataImmediately();
                controllerBE.method_5431();
            }
        }

        return class_1269.field_5812;
    }

    @Override
    public Class<FluidTankBlockEntity> getBlockEntityClass() {
        return FluidTankBlockEntity.class;
    }

    @Override
    public class_2591<? extends FluidTankBlockEntity> getBlockEntityType() {
        return creative ? AllBlockEntityTypes.CREATIVE_FLUID_TANK : AllBlockEntityTypes.FLUID_TANK;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11302)
            return state;
        boolean x = mirror == class_2415.field_11301;
        switch (state.method_11654(SHAPE)) {
            case WINDOW_NE:
                return state.method_11657(SHAPE, x ? Shape.WINDOW_NW : Shape.WINDOW_SE);
            case WINDOW_NW:
                return state.method_11657(SHAPE, x ? Shape.WINDOW_NE : Shape.WINDOW_SW);
            case WINDOW_SE:
                return state.method_11657(SHAPE, x ? Shape.WINDOW_SW : Shape.WINDOW_NE);
            case WINDOW_SW:
                return state.method_11657(SHAPE, x ? Shape.WINDOW_SE : Shape.WINDOW_NW);
            default:
                return state;
        }
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        for (int i = 0; i < rotation.ordinal(); i++)
            state = rotateOnce(state);
        return state;
    }

    private class_2680 rotateOnce(class_2680 state) {
        switch (state.method_11654(SHAPE)) {
            case WINDOW_NE:
                return state.method_11657(SHAPE, Shape.WINDOW_SE);
            case WINDOW_NW:
                return state.method_11657(SHAPE, Shape.WINDOW_NE);
            case WINDOW_SE:
                return state.method_11657(SHAPE, Shape.WINDOW_SW);
            case WINDOW_SW:
                return state.method_11657(SHAPE, Shape.WINDOW_NW);
            default:
                return state;
        }
    }

    public enum Shape implements class_3542 {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos) {
        return getBlockEntityOptional(worldIn, pos).map(FluidTankBlockEntity::getControllerBE)
            .map(be -> ComparatorUtil.fractionToRedstoneLevel(be.getFillState())).orElse(0);
    }

    public static void updateBoilerState(class_2680 pState, class_1937 pLevel, class_2338 tankPos) {
        class_2680 tankState = pLevel.method_8320(tankPos);
        if (!(tankState.method_26204() instanceof FluidTankBlock tank))
            return;
        FluidTankBlockEntity tankBE = tank.getBlockEntity(pLevel, tankPos);
        if (tankBE == null)
            return;
        FluidTankBlockEntity controllerBE = tankBE.getControllerBE();
        if (controllerBE == null)
            return;
        controllerBE.updateBoilerState();
    }

}
