package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.IRotate.SpeedLevel;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class KineticEffectHandler {

    int overStressedTime;
    public float overStressedEffect;
    int particleSpawnCountdown;
    KineticBlockEntity kte;

    public KineticEffectHandler(KineticBlockEntity kte) {
        this.kte = kte;
    }

    public void tick() {
        class_1937 world = kte.method_10997();

        if (world.field_9236) {
            if (overStressedTime > 0)
                if (--overStressedTime == 0)
                    if (kte.isOverStressed()) {
                        overStressedEffect = 1;
                        spawnEffect(class_2398.field_11251, 0.2f, 5);
                    } else {
                        overStressedEffect = -1;
                        spawnEffect(class_2398.field_11204, .075f, 2);
                    }

            if (overStressedEffect != 0) {
                overStressedEffect -= overStressedEffect * .1f;
                if (Math.abs(overStressedEffect) < 1 / 128f)
                    overStressedEffect = 0;
            }

        } else if (particleSpawnCountdown > 0) {
            if (--particleSpawnCountdown == 0)
                spawnRotationIndicators();
        }
    }

    public void queueRotationIndicators() {
        particleSpawnCountdown = 2;
    }

    public void spawnEffect(class_2394 particle, float maxMotion, int amount) {
        class_1937 world = kte.method_10997();
        if (world == null)
            return;
        if (!world.field_9236)
            return;
        class_5819 r = world.field_9229;
        for (int i = 0; i < amount; i++) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, r, maxMotion);
            class_243 position = VecHelper.getCenterOf(kte.method_11016());
            world.method_8406(particle, position.field_1352, position.field_1351, position.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    public void spawnRotationIndicators() {
        float speed = kte.getSpeed();
        if (speed == 0)
            return;

        class_2680 state = kte.method_11010();
        class_2248 block = state.method_26204();
        if (!(block instanceof KineticBlock kb))
            return;

        float radius1 = kb.getParticleInitialRadius();
        float radius2 = kb.getParticleTargetRadius();

        class_2351 axis = kb.getRotationAxis(state);
        class_2338 pos = kte.method_11016();
        class_1937 world = kte.method_10997();
        if (axis == null)
            return;
        if (world == null)
            return;

        class_243 vec = VecHelper.getCenterOf(pos);
        SpeedLevel speedLevel = SpeedLevel.of(speed);
        int color = speedLevel.getColor();
        int particleSpeed = speedLevel.getParticleSpeed();
        particleSpeed *= Math.signum(speed);

        if (world instanceof class_3218 serverWorld) {
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, radius1, radius2, 10, axis);
            serverWorld.method_65096(particleData, vec.field_1352, vec.field_1351, vec.field_1350, 20, 0, 0, 0, 1);
        }
    }

    public void triggerOverStressedEffect() {
        overStressedTime = overStressedTime == 0 ? 2 : 0;
    }

}