package com.zurrtum.create.content.kinetics.belt.item;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.NotNull;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BeltConnectorItem extends class_1747 {

    public BeltConnectorItem(class_1793 properties) {
        super(AllBlocks.BELT, properties);
    }

    @NotNull
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 playerEntity = context.method_8036();
        class_1799 heldStack = context.method_8041();

        if (playerEntity != null && playerEntity.method_5715()) {
            heldStack.method_57381(AllDataComponents.BELT_FIRST_SHAFT);
            return class_1269.field_5812;
        }

        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        boolean validAxis = validateAxis(world, pos);

        if (world.field_9236)
            return validAxis ? class_1269.field_5812 : class_1269.field_5814;

        class_2338 firstPulley = null;

        // Remove first if no longer existant or valid
        if (heldStack.method_57826(AllDataComponents.BELT_FIRST_SHAFT)) {
            firstPulley = heldStack.method_58694(AllDataComponents.BELT_FIRST_SHAFT);
            if (!validateAxis(world, firstPulley) || !firstPulley.method_19771(pos, maxLength() * 2)) {
                heldStack.method_57381(AllDataComponents.BELT_FIRST_SHAFT);
            }
        }

        if (!validAxis || playerEntity == null)
            return class_1269.field_5814;

        if (heldStack.method_57826(AllDataComponents.BELT_FIRST_SHAFT)) {

            if (!canConnect(world, firstPulley, pos))
                return class_1269.field_5814;

            if (firstPulley != null && !firstPulley.equals(pos)) {
                createBelts(world, firstPulley, pos);
                if (playerEntity instanceof class_3222 serverPlayerEntity) {
                    AllAdvancements.BELT.trigger(serverPlayerEntity);
                }
                if (!playerEntity.method_68878())
                    heldStack.method_7934(1);
            }

            if (!heldStack.method_7960()) {
                heldStack.method_57381(AllDataComponents.BELT_FIRST_SHAFT);
                playerEntity.method_7357().method_62835(heldStack, 5);
            }
            return class_1269.field_5812;
        }

        heldStack.method_57379(AllDataComponents.BELT_FIRST_SHAFT, pos);
        playerEntity.method_7357().method_62835(heldStack, 5);
        return class_1269.field_5812;
    }

    public static void createBelts(class_1937 world, class_2338 start, class_2338 end) {
        world.method_8396(
            null,
            class_2338.method_49638(VecHelper.getCenterOf(start.method_10081(end)).method_1021(.5f)),
            class_3417.field_15226,
            class_3419.field_15245,
            0.5F,
            1F
        );

        BeltSlope slope = getSlopeBetween(start, end);
        class_2350 facing = getFacingFromTo(start, end);

        class_2338 diff = end.method_10059(start);
        if (diff.method_10263() == diff.method_10260())
            facing = class_2350.method_10156(facing.method_10171(), world.method_8320(start).method_11654(class_2741.field_12496) == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048);

        List<class_2338> beltsToCreate = getBeltChainBetween(start, end, slope, facing);
        class_2680 beltBlock = AllBlocks.BELT.method_9564();
        boolean failed = false;

        for (class_2338 pos : beltsToCreate) {
            class_2680 existingBlock = world.method_8320(pos);
            if (existingBlock.method_26214(world, pos) == -1) {
                failed = true;
                break;
            }

            BeltPart part = pos.equals(start) ? BeltPart.START : pos.equals(end) ? BeltPart.END : BeltPart.MIDDLE;
            class_2680 shaftState = world.method_8320(pos);
            boolean pulley = ShaftBlock.isShaft(shaftState);
            if (part == BeltPart.MIDDLE && pulley)
                part = BeltPart.PULLEY;
            if (pulley && shaftState.method_11654(AbstractSimpleShaftBlock.AXIS) == class_2351.field_11052)
                slope = BeltSlope.SIDEWAYS;

            if (!existingBlock.method_45474())
                world.method_22352(pos, false);

            KineticBlockEntity.switchToBlockState(
                world,
                pos,
                ProperWaterloggedBlock.withWater(
                    world,
                    beltBlock.method_11657(BeltBlock.SLOPE, slope).method_11657(BeltBlock.PART, part).method_11657(BeltBlock.HORIZONTAL_FACING, facing),
                    pos
                )
            );
        }

        if (!failed)
            return;

        for (class_2338 pos : beltsToCreate)
            if (world.method_8320(pos).method_27852(AllBlocks.BELT))
                world.method_22352(pos, false);
    }

    private static class_2350 getFacingFromTo(class_2338 start, class_2338 end) {
        class_2351 beltAxis = start.method_10263() == end.method_10263() ? class_2351.field_11051 : class_2351.field_11048;
        class_2338 diff = end.method_10059(start);
        class_2352 axisDirection = class_2352.field_11056;

        if (diff.method_10263() == 0 && diff.method_10260() == 0)
            axisDirection = diff.method_10264() > 0 ? class_2352.field_11056 : class_2352.field_11060;
        else
            axisDirection = beltAxis.method_10173(diff.method_10263(), 0, diff.method_10260()) > 0 ? class_2352.field_11056 : class_2352.field_11060;

        return class_2350.method_10156(axisDirection, beltAxis);
    }

    private static BeltSlope getSlopeBetween(class_2338 start, class_2338 end) {
        class_2338 diff = end.method_10059(start);

        if (diff.method_10264() != 0) {
            if (diff.method_10260() != 0 || diff.method_10263() != 0)
                return diff.method_10264() > 0 ? BeltSlope.UPWARD : BeltSlope.DOWNWARD;
            return BeltSlope.VERTICAL;
        }
        return BeltSlope.HORIZONTAL;
    }

    private static List<class_2338> getBeltChainBetween(class_2338 start, class_2338 end, BeltSlope slope, class_2350 direction) {
        List<class_2338> positions = new LinkedList<>();
        int limit = 1000;
        class_2338 current = start;

        do {
            positions.add(current);

            if (slope == BeltSlope.VERTICAL) {
                current = current.method_10086(direction.method_10171() == class_2352.field_11056 ? 1 : -1);
                continue;
            }

            current = current.method_10093(direction);
            if (slope != BeltSlope.HORIZONTAL)
                current = current.method_10086(slope == BeltSlope.UPWARD ? 1 : -1);

        } while (!current.equals(end) && limit-- > 0);

        positions.add(end);
        return positions;
    }

    public static boolean canConnect(class_1937 world, class_2338 first, class_2338 second) {
        if (!world.method_8477(first) || !world.method_8477(second))
            return false;
        if (!second.method_19771(first, maxLength()))
            return false;

        class_2338 diff = second.method_10059(first);
        class_2351 shaftAxis = world.method_8320(first).method_11654(class_2741.field_12496);

        int x = diff.method_10263();
        int y = diff.method_10264();
        int z = diff.method_10260();
        int sames = ((Math.abs(x) == Math.abs(y)) ? 1 : 0) + ((Math.abs(y) == Math.abs(z)) ? 1 : 0) + ((Math.abs(z) == Math.abs(x)) ? 1 : 0);

        if (shaftAxis.method_10173(x, y, z) != 0)
            return false;
        if (sames != 1)
            return false;
        if (shaftAxis != world.method_8320(second).method_11654(class_2741.field_12496))
            return false;
        if (shaftAxis == class_2351.field_11052 && x != 0 && z != 0)
            return false;

        class_2586 blockEntity = world.method_8321(first);
        class_2586 blockEntity2 = world.method_8321(second);

        if (!(blockEntity instanceof KineticBlockEntity))
            return false;
        if (!(blockEntity2 instanceof KineticBlockEntity))
            return false;

        float speed1 = ((KineticBlockEntity) blockEntity).getTheoreticalSpeed();
        float speed2 = ((KineticBlockEntity) blockEntity2).getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0 && speed2 != 0)
            return false;

        class_2338 step = class_2338.method_49637(Math.signum(diff.method_10263()), Math.signum(diff.method_10264()), Math.signum(diff.method_10260()));
        int limit = 1000;
        for (class_2338 currentPos = first.method_10081(step); !currentPos.equals(second) && limit-- > 0; currentPos = currentPos.method_10081(step)) {
            class_2680 blockState = world.method_8320(currentPos);
            if (ShaftBlock.isShaft(blockState) && blockState.method_11654(AbstractSimpleShaftBlock.AXIS) == shaftAxis)
                continue;
            if (!blockState.method_45474())
                return false;
        }

        return true;

    }

    public static Integer maxLength() {
        return AllConfigs.server().kinetics.maxBeltLength.get();
    }

    public static boolean validateAxis(class_1937 world, class_2338 pos) {
        if (!world.method_8477(pos))
            return false;
        if (!ShaftBlock.isShaft(world.method_8320(pos)))
            return false;
        return true;
    }

}
