package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Optional;
import net.minecraft.class_10286;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_8786;
import net.minecraft.class_9334;

public class ManualApplicationHelper {
    public static class_1269 manualApplicationRecipesApplyInWorld(
        class_1937 level,
        class_1657 player,
        class_1799 heldItem,
        class_1268 hand,
        class_3965 hit,
        class_2338 pos
    ) {
        class_2680 blockState = level.method_8320(pos);

        if (heldItem.method_7960())
            return null;
        if (blockState.method_26215())
            return null;

        class_1799 block = blockState.method_26204().method_8389().method_7854();
        if (level.field_9236) {
            class_10286 recipeManager = level.method_8433();
            if (recipeManager.method_64678(AllRecipeSets.ITEM_APPLICATION_TARGET)
                .method_64701(block) && recipeManager.method_64678(AllRecipeSets.ITEM_APPLICATION_INGREDIENT).method_64701(heldItem)) {
                return class_1269.field_5812;
            }
            return null;
        }

        ItemApplicationInput input = new ItemApplicationInput(block, heldItem);
        Optional<class_8786<ManualApplicationRecipe>> foundRecipe = ((class_3218) level).method_64577()
            .method_8132(AllRecipeTypes.ITEM_APPLICATION, input, level);
        if (foundRecipe.isEmpty()) {
            return null;
        }

        level.method_8396(null, pos, class_3417.field_26960, class_3419.field_15248, 1, 1.45f);
        ManualApplicationRecipe recipe = foundRecipe.get().comp_1933();
        level.method_22352(pos, false);

        class_1799 stack = recipe.craft(input, level.method_30349());
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747 blockItem) {
            class_2680 transformedBlock = BlockHelper.copyProperties(blockState, blockItem.method_7711().method_9564());
            level.method_8652(pos, transformedBlock, class_2248.field_31036);
            awardAdvancements((class_3222) player, transformedBlock);
        } else {
            class_2248.method_9577(level, pos, stack);
        }

        if (!heldItem.method_57826(class_9334.field_49630) && !player.method_68878() && !recipe.keepHeldItem()) {
            if (heldItem.method_7936() > 0) {
                heldItem.method_7970(1, player, class_1304.field_6173);
            } else {
                class_1799 leftover = heldItem.method_7909().method_7858();
                heldItem.method_7934(1);
                if (!leftover.method_7960()) {
                    if (heldItem.method_7960()) {
                        player.method_6122(hand, leftover);
                    } else if (!player.method_31548().method_7394(leftover)) {
                        player.method_7328(leftover, false);
                    }
                }
            }
        }
        return class_1269.field_5812;
    }

    private static void awardAdvancements(class_3222 player, class_2680 placed) {
        CreateTrigger advancement;

        if (placed.method_27852(AllBlocks.ANDESITE_CASING))
            advancement = AllAdvancements.ANDESITE_CASING;
        else if (placed.method_27852(AllBlocks.BRASS_CASING))
            advancement = AllAdvancements.BRASS_CASING;
        else if (placed.method_27852(AllBlocks.COPPER_CASING))
            advancement = AllAdvancements.COPPER_CASING;
        else if (placed.method_27852(AllBlocks.RAILWAY_CASING))
            advancement = AllAdvancements.TRAIN_CASING;
        else
            return;

        advancement.trigger(player);
    }
}