package com.zurrtum.create.content.kinetics.gauge;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VoxelShaper;
import java.util.Arrays;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;

public class GaugeShaper extends VoxelShaper {

    private VoxelShaper axisFalse, axisTrue;

    static GaugeShaper make() {
        GaugeShaper shaper = new GaugeShaper();
        shaper.axisFalse = forDirectional(AllShapes.GAUGE_SHAPE_UP, class_2350.field_11036);
        shaper.axisTrue = forDirectional(rotatedCopy(AllShapes.GAUGE_SHAPE_UP, new class_243(0, 90, 0)), class_2350.field_11036);
        //shapes for X axis need to be swapped
        Arrays.asList(class_2350.field_11034, class_2350.field_11039).forEach(direction -> {
            class_265 mem = shaper.axisFalse.get(direction);
            shaper.axisFalse.withShape(shaper.axisTrue.get(direction), direction);
            shaper.axisTrue.withShape(mem, direction);
        });
        return shaper;
    }

    public class_265 get(class_2350 direction, boolean axisAlong) {
        return (axisAlong ? axisTrue : axisFalse).get(direction);
    }
}
