package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity.Phase;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9904;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ArmBlock extends KineticBlock implements IBE<ArmBlockEntity>, ICogWheel {

    public static final class_2746 CEILING = class_2746.method_11825("ceiling");

    public ArmBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(CEILING, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(CEILING));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(CEILING, ctx.method_8038() == class_2350.field_11033);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return state.method_11654(CEILING) ? AllShapes.MECHANICAL_ARM_CEILING : AllShapes.MECHANICAL_ARM;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, world, pos, oldState, isMoving);
        withBlockEntityDo(world, pos, ArmBlockEntity::redstoneUpdate);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_2248 p_220069_4_,
        @Nullable class_9904 wireOrientation,
        boolean p_220069_6_
    ) {
        withBlockEntityDo(world, pos, ArmBlockEntity::redstoneUpdate);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return class_2351.field_11052;
    }

    @Override
    public Class<ArmBlockEntity> getBlockEntityClass() {
        return ArmBlockEntity.class;
    }

    @Override
    public class_2591<? extends ArmBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_ARM;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (stack.method_31574(AllItems.GOGGLES)) {
            class_1269 gogglesResult = onBlockEntityUseItemOn(
                level, pos, ate -> {
                    if (ate.goggles)
                        return class_1269.field_52423;
                    ate.goggles = true;
                    ate.notifyUpdate();
                    return class_1269.field_5812;
                }
            );
            if (gogglesResult.method_23665())
                return gogglesResult;
        }

        MutableBoolean success = new MutableBoolean(false);
        withBlockEntityDo(
            level, pos, be -> {
                if (be.heldItem.method_7960())
                    return;
                success.setTrue();
                if (level.field_9236)
                    return;
                player.method_31548().method_7398(be.heldItem);
                be.heldItem = class_1799.field_8037;
                be.phase = Phase.SEARCH_INPUTS;
                be.method_5431();
                be.sendData();
            }
        );

        return success.booleanValue() ? class_1269.field_5812 : class_1269.field_52423;
    }

}
