package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.utility.AbstractBlockBreakQueue;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2279;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2397;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TreeCutter {

    public static final Tree NO_TREE = new Tree(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    //TODO
    //    public static boolean canDynamicTreeCutFrom(Block startBlock) {
    //        return Mods.DYNAMICTREES.runIfInstalled(() -> () -> DynamicTree.isDynamicBranch(startBlock)).orElse(false);
    //    }
    //
    //    @NotNull
    //    public static Optional<AbstractBlockBreakQueue> findDynamicTree(Block startBlock, BlockPos pos) {
    //        if (canDynamicTreeCutFrom(startBlock))
    //            return Mods.DYNAMICTREES.runIfInstalled(() -> () -> new DynamicTree(pos));
    //        return Optional.empty();
    //    }

    /**
     * Finds a tree at the given pos. Block at the position should be air
     *
     * @param reader      the level that will be searched for a tree
     * @param pos         position that the saw cut at
     * @param brokenState block state what was broken by the saw
     */
    @NotNull
    public static Tree findTree(@Nullable class_1922 reader, class_2338 pos, class_2680 brokenState) {
        if (reader == null)
            return NO_TREE;

        List<class_2338> logs = new ArrayList<>();
        List<class_2338> leaves = new ArrayList<>();
        List<class_2338> attachments = new ArrayList<>();
        Set<class_2338> visited = new HashSet<>();
        List<class_2338> frontier = new LinkedList<>();

        class_2680 stateAbove = reader.method_8320(pos.method_10084());
        // Bamboo, Sugar Cane, Cactus
        if (isVerticalPlant(brokenState)) {
            if (!isVerticalPlant(stateAbove))
                return NO_TREE;

            logs.add(pos.method_10084());
            for (int i = 1; i < reader.method_31605(); i++) {
                class_2338 current = pos.method_10086(i);
                if (!isVerticalPlant(reader.method_8320(current)))
                    break;
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }

        // Chorus
        if (isChorus(brokenState)) {
            if (!isChorus(stateAbove))
                return NO_TREE;

            frontier.add(pos.method_10084());
            while (!frontier.isEmpty()) {
                class_2338 current = frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (class_2350 direction : Iterate.directions) {
                    class_2338 offset = current.method_10093(direction);
                    if (visited.contains(offset))
                        continue;
                    if (!isChorus(reader.method_8320(offset)))
                        continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }

        // Regular Tree
        if (!validateCut(reader, pos))
            return NO_TREE;

        visited.add(pos);
        class_2338.method_20437(pos.method_10069(-1, 0, -1), pos.method_10069(1, 1, 1)).forEach(p -> frontier.add(new class_2338(p)));

        // Find all logs & roots
        boolean hasRoots = false;
        while (!frontier.isEmpty()) {
            class_2338 currentPos = frontier.remove(0);
            if (!visited.add(currentPos))
                continue;

            class_2680 currentState = reader.method_8320(currentPos);
            if (isRoot(currentState))
                hasRoots = true;
            else if (!isLog(currentState))
                continue;
            logs.add(currentPos);
            forNeighbours(currentPos, visited, SearchDirection.UP, p -> frontier.add(new class_2338(p)));
        }

        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);

        if (hasRoots) {
            Set<class_2338> oldLogs = new HashSet<>(logs);
            while (!frontier.isEmpty()) {
                class_2338 currentPos = frontier.remove(0);

                class_2680 currentState = reader.method_8320(currentPos);
                if (!isRoot(currentState))
                    continue;
                if (!oldLogs.contains(currentPos))
                    logs.add(currentPos);
                forNeighbours(
                    currentPos, visited, SearchDirection.DOWN, p -> {
                        class_2338 neighbourPos = p.method_10062();
                        if (visited.add(neighbourPos))
                            frontier.add(neighbourPos);
                    }
                );
            }

            visited.clear();
            visited.addAll(logs);
            frontier.addAll(logs);
        }

        // Find all leaves
        while (!frontier.isEmpty()) {
            class_2338 prevPos = frontier.remove(0);

            class_2680 prevState = reader.method_8320(prevPos);
            int prevLeafDistance = isLeaf(prevState) ? getLeafDistance(prevState) : 0;

            forNeighbours(
                prevPos, visited, SearchDirection.BOTH, currentPos -> {
                    class_2680 state = reader.method_8320(currentPos);
                    class_2338 subtract = currentPos.method_10059(pos);
                    class_2338 currentPosImmutable = currentPos.method_10062();

                    if (state.method_26164(AllBlockTags.TREE_ATTACHMENTS)) {
                        attachments.add(currentPosImmutable);
                        visited.add(currentPosImmutable);
                        return;
                    }

                    int horizontalDistance = Math.max(Math.abs(subtract.method_10263()), Math.abs(subtract.method_10260()));
                    if (horizontalDistance <= nonDecayingLeafDistance(state) && visited.add(currentPosImmutable)) {
                        leaves.add(currentPosImmutable);
                        frontier.add(currentPosImmutable);
                        return;
                    }

                    if (isLeaf(state) && getLeafDistance(state) > prevLeafDistance && visited.add(currentPosImmutable)) {
                        leaves.add(currentPosImmutable);
                        frontier.add(currentPosImmutable);
                        return;
                    }

                }
            );
        }
        return new Tree(logs, leaves, attachments);
    }

    private static int getLeafDistance(class_2680 state) {
        class_2758 distanceProperty = class_2397.field_11199;
        for (class_2769<?> property : state.method_11656().keySet())
            if (property instanceof class_2758 ip && property.method_11899().equals("distance"))
                distanceProperty = ip;
        return state.method_11654(distanceProperty);
    }

    public static boolean isChorus(class_2680 stateAbove) {
        return stateAbove.method_26204() instanceof class_2283 || stateAbove.method_26204() instanceof class_2279;
    }

    public static boolean isVerticalPlant(class_2680 stateAbove) {
        class_2248 block = stateAbove.method_26204();
        if (block instanceof class_2211)
            return true;
        if (block instanceof class_2266)
            return true;
        if (block instanceof class_2523)
            return true;
        if (block instanceof class_2391)
            return true;
        return block instanceof class_2393;
    }

    /**
     * Checks whether a tree was fully cut by seeing whether the layer above the cut
     * is not supported by any more logs.
     *
     * @param reader
     * @param pos
     * @return
     */
    private static boolean validateCut(class_1922 reader, class_2338 pos) {
        Set<class_2338> visited = new HashSet<>();
        List<class_2338> frontier = new LinkedList<>();
        frontier.add(pos);
        frontier.add(pos.method_10084());
        int posY = pos.method_10264();

        while (!frontier.isEmpty()) {
            class_2338 currentPos = frontier.remove(0);
            class_2338 belowPos = currentPos.method_10074();

            visited.add(currentPos);
            boolean lowerLayer = currentPos.method_10264() == posY;

            class_2680 currentState = reader.method_8320(currentPos);
            class_2680 belowState = reader.method_8320(belowPos);

            if (!isLog(currentState) && !isRoot(currentState))
                continue;
            if (!lowerLayer && !pos.equals(belowPos) && (isLog(belowState) || isRoot(belowState)))
                return false;

            for (class_2350 direction : Iterate.directions) {
                if (direction == class_2350.field_11033)
                    continue;
                if (direction == class_2350.field_11036 && !lowerLayer)
                    continue;
                class_2338 offset = currentPos.method_10093(direction);
                if (visited.contains(offset))
                    continue;
                frontier.add(offset);
            }

        }

        return true;
    }

    private enum SearchDirection {
        UP(0, 1),
        DOWN(-1, 0),
        BOTH(-1, 1);

        int minY;
        int maxY;

        private SearchDirection(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
        }
    }

    private static void forNeighbours(class_2338 pos, Set<class_2338> visited, SearchDirection direction, Consumer<class_2338> acceptor) {
        class_2338.method_20437(pos.method_10069(-1, direction.minY, -1), pos.method_10069(1, direction.maxY, 1)).filter(((Predicate<class_2338>) visited::contains).negate())
            .forEach(acceptor);
    }

    public static boolean isRoot(class_2680 state) {
        return state.method_26164(AllBlockTags.ROOTS);
    }

    public static boolean isLog(class_2680 state) {
        return state.method_26164(class_3481.field_15475) || state.method_26164(AllBlockTags.SLIMY_LOGS) || state.method_27852(class_2246.field_10556);
    }

    private static int nonDecayingLeafDistance(class_2680 state) {
        if (state.method_27852(class_2246.field_10240))
            return 2;
        if (state.method_27852(class_2246.field_10580))
            return 3;
        if (state.method_26164(class_3481.field_21954) || state.method_27852(class_2246.field_22123) || state.method_27852(class_2246.field_22124))
            return 3;
        return -1;
    }

    private static boolean isLeaf(class_2680 state) {
        for (class_2769<?> property : state.method_11656().keySet())
            if (property instanceof class_2758 && property.method_11899().equals("distance") && property != class_2741.field_16503)
                return true;
        return false;
    }

    public static class Tree extends AbstractBlockBreakQueue {
        private final List<class_2338> logs;
        private final List<class_2338> leaves;
        private final List<class_2338> attachments;

        public Tree(List<class_2338> logs, List<class_2338> leaves, List<class_2338> attachments) {
            this.logs = logs;
            this.leaves = leaves;
            this.attachments = attachments;
        }

        @Override
        public void destroyBlocks(class_1937 world, class_1799 toDamage, @Nullable class_1657 playerEntity, BiConsumer<class_2338, class_1799> drop) {
            attachments.forEach(makeCallbackFor(world, 1 / 32f, toDamage, playerEntity, drop));
            logs.forEach(makeCallbackFor(world, 1 / 2f, toDamage, playerEntity, drop));
            leaves.forEach(makeCallbackFor(world, 1 / 8f, toDamage, playerEntity, drop));
        }
    }
}
