package com.zurrtum.create.content.logistics.chute;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChuteBlock extends class_2248 implements IWrenchable, IBE<ChuteBlockEntity>, ItemInventoryProvider<ChuteBlockEntity>, NeighborUpdateListeningBlock {

    public AbstractChuteBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, ChuteBlockEntity blockEntity, class_2350 context) {
        return blockEntity.itemHandler;
    }

    public static boolean isChute(class_2680 state) {
        return state.method_26204() instanceof AbstractChuteBlock;
    }

    public static boolean isOpenChute(class_2680 state) {
        return isChute(state) && ((AbstractChuteBlock) state.method_26204()).isOpen(state);
    }

    public static boolean isTransparentChute(class_2680 state) {
        return isChute(state) && ((AbstractChuteBlock) state.method_26204()).method_9579(state);
    }

    @Nullable
    public static class_2350 getChuteFacing(class_2680 state) {
        return !isChute(state) ? null : ((AbstractChuteBlock) state.method_26204()).getFacing(state);
    }

    public class_2350 getFacing(class_2680 state) {
        return class_2350.field_11033;
    }

    public boolean isOpen(class_2680 state) {
        return true;
    }

    public boolean method_9579(class_2680 state) {
        return false;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        class_1799 stack = ItemHelper.fromItemEntity(entityIn);
        if (stack.method_7960())
            return;
        if (entityIn.method_37908().field_9236)
            return;
        if (!entityIn.method_5805())
            return;
        class_2338 pos = class_2338.method_49638(entityIn.method_19538().method_1031(0, 0.5f, 0)).method_10074();
        DirectBeltInputBehaviour input = BlockEntityBehaviour.get(entityIn.method_37908(), pos, DirectBeltInputBehaviour.TYPE);
        if (input == null)
            return;
        if (!input.canInsertFromSide(class_2350.field_11036))
            return;
        if (!PackageEntity.centerPackage(entityIn, class_243.method_24955(pos.method_10084())))
            return;
        class_1799 remainder = input.handleInsertion(stack, class_2350.field_11036, false);
        if (remainder.method_7960()) {
            entityIn.method_31472();
            if (entityIn instanceof PackageEntity box) {
                class_1657 player = box.tossedBy.get();
                if (player instanceof class_3222 serverPlayer)
                    AllAdvancements.PACKAGE_CHUTE_THROW.trigger(serverPlayer);
            }
        } else if (remainder.method_7947() < stack.method_7947() && entityIn instanceof class_1542 itemEntity)
            itemEntity.method_6979(remainder);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 p_220082_4_, boolean p_220082_5_) {
        withBlockEntityDo(world, pos, ChuteBlockEntity::onAdded);
        updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(class_2680 state, class_1937 world, class_2338 pos) {
        if (!isChute(state))
            return;
        AbstractChuteBlock block = (AbstractChuteBlock) state.method_26204();
        class_2350 facing = block.getFacing(state);
        class_2338 toUpdate = pos.method_10074();
        if (facing.method_10166().method_10179())
            toUpdate = toUpdate.method_10093(facing.method_10153());

        class_2680 stateToUpdate = world.method_8320(toUpdate);
        if (isChute(stateToUpdate) && !world.method_8397().method_8674(toUpdate, stateToUpdate.method_26204()))
            world.method_64310(toUpdate, stateToUpdate.method_26204(), 1);
    }

    @Override
    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean isMoving) {
        updateDiagonalNeighbour(state, world, pos);

        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2338 toUpdate = pos.method_10084().method_10093(direction);
            class_2680 stateToUpdate = world.method_8320(toUpdate);
            if (isChute(stateToUpdate) && !world.method_14196().method_8674(toUpdate, stateToUpdate.method_26204()))
                world.method_64310(toUpdate, stateToUpdate.method_26204(), 1);
        }
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        class_2680 updated = updateChuteState(pState, pLevel.method_8320(pPos.method_10084()), pLevel, pPos);
        if (pState != updated)
            pLevel.method_8501(pPos, updated);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 p_196271_6_,
        class_2680 above,
        class_5819 random
    ) {
        if (direction != class_2350.field_11036)
            return state;
        return updateChuteState(state, above, world, pos);
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 neighbourPos, boolean isMoving) {
        if (pos.method_10074().equals(neighbourPos))
            withBlockEntityDo(world, pos, ChuteBlockEntity::blockBelowChanged);
    }

    public abstract class_2680 updateChuteState(class_2680 state, class_2680 above, class_1922 world, class_2338 pos);

    @Override
    public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    @Override
    public class_265 method_9549(class_2680 p_220071_1_, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    @Override
    public Class<ChuteBlockEntity> getBlockEntityClass() {
        return ChuteBlockEntity.class;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!stack.method_7960())
            return class_1269.field_52423;
        if (level.field_9236)
            return class_1269.field_5812;

        return onBlockEntityUseItemOn(
            level, pos, be -> {
                if (be.item.method_7960())
                    return class_1269.field_52423;
                player.method_31548().method_7398(be.item);
                be.setItem(class_1799.field_8037);
                return class_1269.field_5812;
            }
        );
    }

}
