package com.zurrtum.create.content.logistics.chute;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper.ExtractionCountMode;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SmartChuteBlockEntity extends ChuteBlockEntity {

    ServerFilteringBehaviour filtering;

    public SmartChuteBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SMART_CHUTE, pos, state);
    }

    @Override
    protected boolean canAcceptItem(class_1799 stack) {
        return super.canAcceptItem(stack) && canActivate() && filtering.test(stack);
    }

    @Override
    protected int getExtractionAmount() {
        return filtering.isCountVisible() && !filtering.anyAmount() ? filtering.getAmount() : 64;
    }

    @Override
    protected ExtractionCountMode getExtractionMode() {
        return filtering.isCountVisible() && !filtering.anyAmount() && !filtering.upTo ? ExtractionCountMode.EXACTLY : ExtractionCountMode.UPTO;
    }

    @Override
    protected boolean canActivate() {
        class_2680 blockState = method_11010();
        return blockState.method_28498(SmartChuteBlock.POWERED) && !blockState.method_11654(SmartChuteBlock.POWERED);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(filtering = new ServerFilteringBehaviour(this).showCountWhen(this::isExtracting).withCallback($ -> invVersionTracker.reset()));
        super.addBehaviours(behaviours);
    }

    private boolean isExtracting() {
        boolean up = getItemMotion() < 0;
        class_2338 chutePos = field_11867.method_10093(up ? class_2350.field_11036 : class_2350.field_11033);
        class_2680 blockState = field_11863.method_8320(chutePos);
        return !AbstractChuteBlock.isChute(blockState) && !blockState.method_45474();
    }

}
