package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9334;

public class AttributeFilterMenu extends AbstractFilterMenu {

    public AttributeFilterWhitelistMode whitelistMode;
    public List<ItemAttributeEntry> selectedAttributes;

    public AttributeFilterMenu(int id, class_1661 inv, class_1799 stack) {
        super(AllMenuTypes.ATTRIBUTE_FILTER, id, inv, stack);
    }

    public void appendSelectedAttribute(ItemAttribute itemAttribute, boolean inverted) {
        selectedAttributes.add(new ItemAttributeEntry(itemAttribute, inverted));
    }

    @Override
    protected void init(class_1661 inv, class_1799 contentHolder) {
        super.init(inv, contentHolder);
        class_1799 stack = new class_1799(class_1802.field_8448);
        stack.method_57379(class_9334.field_49631, class_2561.method_43470("Selected Tags").method_27695(class_124.field_1070, class_124.field_1078));
        ghostInventory.method_5447(1, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    @Override
    protected void addFilterSlots() {
        this.method_7621(new class_1735(ghostInventory, 0, 16, 27));
        this.method_7621(new class_1735(ghostInventory, 1, 16, 62) {
            @Override
            public boolean method_7674(class_1657 playerIn) {
                return false;
            }
        });
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    @Override
    public void clearContents() {
        selectedAttributes.clear();
    }

    @Override
    public void method_7593(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player) {
        if (slotId == 37)
            return;
        super.method_7593(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public boolean method_7615(class_1735 slotIn) {
        if (slotIn.field_7874 == 37)
            return false;
        return super.method_7615(slotIn);
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slotIn) {
        if (slotIn.field_7874 == 37)
            return false;
        return super.method_7613(stack, slotIn);
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        if (index == 37)
            return class_1799.field_8037;
        if (index == 36) {
            ghostInventory.method_5447(37, class_1799.field_8037);
            return class_1799.field_8037;
        }
        if (index < 36) {
            class_1799 stackToInsert = playerInventory.method_5438(index);
            class_1799 copy = stackToInsert.method_7972();
            copy.method_7939(1);
            ghostInventory.method_5447(0, copy);
        }
        return class_1799.field_8037;
    }

    @Override
    protected void initAndReadInventory(class_1799 filterItem) {
        super.initAndReadInventory(filterItem);
        selectedAttributes = new ArrayList<>();
        whitelistMode = filterItem.method_58695(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, AttributeFilterWhitelistMode.WHITELIST_DISJ);
        List<ItemAttributeEntry> attributes = filterItem.method_58695(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, List.of());
        selectedAttributes.addAll(attributes);
    }

    @Override
    protected void saveData(class_1799 filterItem) {
        filterItem.method_57379(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, whitelistMode);
        List<ItemAttributeEntry> attributes = new ArrayList<>();
        selectedAttributes.forEach(at -> {
            if (at == null)
                return;
            attributes.add(new ItemAttributeEntry(at.attribute(), at.inverted()));
        });
        filterItem.method_57379(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, attributes);

        if (attributes.isEmpty() && whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ) {
            filterItem.method_57381(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);
            filterItem.method_57381(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
        }
    }

}