package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.*;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper.ExtractionCountMode;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.FunnelFlapPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.util.math.*;
import org.apache.commons.lang3.mutable.MutableBoolean;

import java.lang.ref.WeakReference;
import java.util.List;

public class FunnelBlockEntity extends SmartBlockEntity {

    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour invManipulation;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private int extractionCooldown;

    private WeakReference<class_1297> lastObserved; // In-world Extractors only

    public LerpedFloat flap;

    enum Mode {
        INVALID,
        PAUSED,
        COLLECT,
        PUSHING_TO_BELT,
        TAKING_FROM_BELT,
        EXTRACT
    }

    public FunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FUNNEL, pos, state);
        extractionCooldown = 0;
        flap = createChasingFlap();
    }

    Mode determineCurrentMode() {
        class_2680 state = method_11010();
        if (!FunnelBlock.isFunnel(state))
            return Mode.INVALID;
        if (state.method_61767(class_2741.field_12484, false))
            return Mode.PAUSED;
        if (state.method_26204() instanceof BeltFunnelBlock) {
            Shape shape = state.method_11654(BeltFunnelBlock.SHAPE);
            if (shape == Shape.PULLING)
                return Mode.TAKING_FROM_BELT;
            if (shape == Shape.PUSHING)
                return Mode.PUSHING_TO_BELT;

            BeltBlockEntity belt = BeltHelper.getSegmentBE(field_11863, field_11867.method_10074());
            if (belt != null)
                return belt.getMovementFacing() == state.method_11654(BeltFunnelBlock.HORIZONTAL_FACING) ? Mode.PUSHING_TO_BELT : Mode.TAKING_FROM_BELT;
            return Mode.INVALID;
        }
        if (state.method_26204() instanceof FunnelBlock)
            return state.method_11654(FunnelBlock.EXTRACTING) ? Mode.EXTRACT : Mode.COLLECT;

        return Mode.INVALID;
    }

    @Override
    public void tick() {
        super.tick();
        flap.tickChaser();
        Mode mode = determineCurrentMode();
        if (field_11863.field_9236)
            return;

        // Redstone resets the extraction cooldown
        if (mode == Mode.PAUSED)
            extractionCooldown = 0;
        if (mode == Mode.TAKING_FROM_BELT)
            return;

        if (extractionCooldown > 0) {
            extractionCooldown--;
            return;
        }

        if (mode == Mode.PUSHING_TO_BELT)
            activateExtractingBeltFunnel();
        if (mode == Mode.EXTRACT)
            activateExtractor();
    }

    private void activateExtractor() {
        if (invVersionTracker.stillWaiting(invManipulation))
            return;

        class_2680 blockState = method_11010();
        class_2350 facing = AbstractFunnelBlock.getFunnelFacing(blockState);

        if (facing == null)
            return;

        boolean trackingEntityPresent = true;
        class_238 area = getEntityOverflowScanningArea();

        // Check if last item is still blocking the extractor
        if (lastObserved == null) {
            trackingEntityPresent = false;
        } else {
            class_1297 lastEntity = lastObserved.get();
            if (lastEntity == null || !lastEntity.method_5805() || !lastEntity.method_5829().method_994(area)) {
                trackingEntityPresent = false;
                lastObserved = null;
            }
        }

        if (trackingEntityPresent)
            return;

        // Find other entities blocking the extract (only if necessary)
        int amountToExtract = getAmountToExtract();
        ExtractionCountMode mode = getModeToExtract();
        class_1799 stack = invManipulation.simulate().extract(mode, amountToExtract);
        if (stack.method_7960()) {
            invVersionTracker.awaitNewVersion(invManipulation);
            return;
        }
        for (class_1297 entity : field_11863.method_8335(null, area)) {
            if (entity instanceof class_1542 || entity instanceof PackageEntity) {
                lastObserved = new WeakReference<>(entity);
                return;
            }
        }

        // Extract
        stack = invManipulation.extract(mode, amountToExtract);
        if (stack.method_7960())
            return;

        flap(false);
        onTransfer(stack);

        class_243 outputPos = VecHelper.getCenterOf(field_11867);
        boolean vertical = facing.method_10166().method_10178();
        boolean up = facing == class_2350.field_11036;

        outputPos = outputPos.method_1019(class_243.method_24954(facing.method_62675()).method_1021(vertical ? up ? .15f : .5f : .25f));
        if (!vertical)
            outputPos = outputPos.method_1023(0, .45f, 0);

        class_243 motion = class_243.field_1353;
        if (up)
            motion = new class_243(0, 4 / 16f, 0);

        class_1542 item = new class_1542(field_11863, outputPos.field_1352, outputPos.field_1351, outputPos.field_1350, stack.method_7972());
        item.method_6988();
        item.method_18799(motion);
        field_11863.method_8649(item);
        lastObserved = new WeakReference<>(item);

        startCooldown();
    }

    static final class_238 coreBB = new class_238(class_2338.field_10980);

    private class_238 getEntityOverflowScanningArea() {
        class_2350 facing = AbstractFunnelBlock.getFunnelFacing(method_11010());
        class_238 bb = coreBB.method_996(field_11867);
        if (facing == null || facing == class_2350.field_11036)
            return bb;
        return bb.method_1012(0, -1, 0);
    }

    private void activateExtractingBeltFunnel() {
        if (invVersionTracker.stillWaiting(invManipulation))
            return;

        class_2680 blockState = method_11010();
        class_2350 facing = blockState.method_11654(BeltFunnelBlock.HORIZONTAL_FACING);
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(field_11863, field_11867.method_10074(), DirectBeltInputBehaviour.TYPE);

        if (inputBehaviour == null)
            return;
        if (!inputBehaviour.canInsertFromSide(facing))
            return;
        if (inputBehaviour.isOccupied(facing))
            return;

        int amountToExtract = getAmountToExtract();
        ExtractionCountMode mode = getModeToExtract();
        MutableBoolean deniedByInsertion = new MutableBoolean(false);
        class_1799 stack = invManipulation.extract(
            mode, amountToExtract, s -> {
                class_1799 handleInsertion = inputBehaviour.handleInsertion(s, facing, true);
                if (handleInsertion.method_7960())
                    return true;
                deniedByInsertion.setTrue();
                return false;
            }
        );
        if (stack.method_7960()) {
            if (deniedByInsertion.isFalse())
                invVersionTracker.awaitNewVersion(invManipulation.getInventory());
            return;
        }
        flap(false);
        onTransfer(stack);
        inputBehaviour.handleInsertion(stack, facing, false);
        startCooldown();
    }

    public int getAmountToExtract() {
        if (!supportsAmountOnFilter())
            return 64;
        int amountToExtract = invManipulation.getAmountFromFilter();
        if (!filtering.isActive())
            amountToExtract = 1;
        return amountToExtract;
    }

    public ExtractionCountMode getModeToExtract() {
        if (!supportsAmountOnFilter() || !filtering.isActive())
            return ExtractionCountMode.UPTO;
        return invManipulation.getModeFromFilter();
    }

    private int startCooldown() {
        return extractionCooldown = AllConfigs.server().logistics.defaultExtractionTimer.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        invManipulation = new InvManipulationBehaviour(this, (w, p, s) -> new BlockFace(p, AbstractFunnelBlock.getFunnelFacing(s).method_10153()));
        behaviours.add(invManipulation);

        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));

        filtering = new ServerFilteringBehaviour(this);
        filtering.showCountWhen(this::supportsAmountOnFilter);
        filtering.onlyActiveWhen(this::supportsFiltering);
        //        filtering.withCallback($ -> invVersionTracker.reset());
        behaviours.add(filtering);

        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput)
            .setInsertionHandler(this::handleDirectBeltInput));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FUNNEL);
    }

    private boolean supportsAmountOnFilter() {
        class_2680 blockState = method_11010();
        boolean beltFunnelsupportsAmount = false;
        if (blockState.method_26204() instanceof BeltFunnelBlock) {
            Shape shape = blockState.method_11654(BeltFunnelBlock.SHAPE);
            if (shape == Shape.PUSHING)
                beltFunnelsupportsAmount = true;
            else
                beltFunnelsupportsAmount = BeltHelper.getSegmentBE(field_11863, field_11867.method_10074()) != null;
        }
        boolean extractor = blockState.method_26204() instanceof FunnelBlock && blockState.method_11654(FunnelBlock.EXTRACTING);
        return beltFunnelsupportsAmount || extractor;
    }

    private boolean supportsDirectBeltInput(class_2350 side) {
        class_2680 blockState = method_11010();
        if (blockState == null)
            return false;
        if (!(blockState.method_26204() instanceof FunnelBlock))
            return false;
        if (blockState.method_11654(FunnelBlock.EXTRACTING))
            return false;
        return FunnelBlock.getFunnelFacing(blockState) == class_2350.field_11036;
    }

    private boolean supportsFiltering() {
        class_2680 blockState = method_11010();
        return blockState.method_27852(AllBlocks.BRASS_BELT_FUNNEL) || blockState.method_27852(AllBlocks.BRASS_FUNNEL);
    }

    private class_1799 handleDirectBeltInput(TransportedItemStack stack, class_2350 side, boolean simulate) {
        class_1799 inserted = stack.stack;
        if (!filtering.test(inserted))
            return inserted;
        if (determineCurrentMode() == Mode.PAUSED)
            return inserted;
        if (simulate)
            invManipulation.simulate();
        if (!simulate)
            onTransfer(inserted);
        return invManipulation.insert(inserted);
    }

    public void flap(boolean inward) {
        if (!field_11863.field_9236 && field_11863 instanceof class_3218 serverLevel) {
            FunnelFlapPacket packet = new FunnelFlapPacket(this, inward);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                player.field_13987.method_14364(packet);
            }
        } else {
            flap.setValue(inward ? -1 : 1);
            AllSoundEvents.FUNNEL_FLAP.playAt(field_11863, field_11867, 1, 1, true);
        }
    }

    public boolean hasFlap() {
        class_2680 blockState = method_11010();
        return AbstractFunnelBlock.getFunnelFacing(blockState).method_10166().method_10179();
    }

    public float getFlapOffset() {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof BeltFunnelBlock))
            return -1 / 16f;
        return switch (blockState.method_11654(BeltFunnelBlock.SHAPE)) {
            case EXTENDED -> 8 / 16f;
            case PULLING, PUSHING -> -2 / 16f;
            default -> 0;
        };
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("TransferCooldown", extractionCooldown);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        extractionCooldown = view.method_71424("TransferCooldown", 0);

        if (clientPacket)
            AllClientHandle.INSTANCE.queueUpdate(this);
    }

    public void onTransfer(class_1799 stack) {
        AllBlocks.SMART_OBSERVER.onFunnelTransfer(field_11863, field_11867, stack);
        award(AllAdvancements.FUNNEL);
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(.25f).chase(0, .05f, Chaser.EXP);
    }

}