package com.zurrtum.create.content.logistics.packagePort;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9129;

public abstract class PackagePortBlockEntity extends SmartBlockEntity implements MenuProvider {

    public boolean acceptsPackages;
    public String addressFilter;
    public PackagePortTarget target;
    public PackagePortInventory inventory;

    protected AnimatedContainerBehaviour<PackagePortMenu> openTracker;

    public PackagePortBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        addressFilter = "";
        acceptsPackages = true;
        inventory = new PackagePortInventory();
    }

    public boolean isBackedUp() {
        for (int i = 0, size = inventory.method_5439(); i < size; i++)
            if (inventory.method_5438(i).method_7960())
                return false;
        return true;
    }

    public void filterChanged() {
        if (target != null) {
            target.deregister(this, field_11863, field_11867);
            target.register(this, field_11863, field_11867);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (target != null)
            target.register(this, field_11863, field_11867);
    }

    public String getFilterString() {
        return acceptsPackages ? addressFilter : null;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (target != null)
            view.method_71468("Target", PackagePortTarget.CODEC, target);
        view.method_71469("AddressFilter", addressFilter);
        view.method_71472("AcceptsPackages", acceptsPackages);
        inventory.write(view);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        inventory.read(view);
        PackagePortTarget prevTarget = target;
        target = view.method_71426("Target", PackagePortTarget.CODEC).orElse(null);
        addressFilter = view.method_71428("AddressFilter", "");
        acceptsPackages = view.method_71433("AcceptsPackages", false);
        if (clientPacket && prevTarget != target)
            invalidateRenderBoundingBox();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        if (target != null)
            target.deregister(this, field_11863, field_11867);
        super.destroy();
        class_1264.method_5451(field_11863, field_11867, inventory);
    }

    public void drop(class_1799 box) {
        if (box.method_7960())
            return;
        class_2248.method_9577(field_11863, field_11867, box);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(openTracker = new AnimatedContainerBehaviour<>(this, PackagePortMenu.class));
        openTracker.onOpenChanged(this::onOpenChange);
    }

    protected abstract void onOpenChange(boolean open);

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276())
            return class_1269.field_52423;
        if (FakePlayerHandler.has(player))
            return class_1269.field_52423;
        class_1799 mainHandItem = player.method_6047();
        boolean clipboard = mainHandItem.method_31574(AllItems.CLIPBOARD);

        if (field_11863.field_9236) {
            if (!clipboard)
                onOpenedManually();
            return class_1269.field_5812;
        }

        if (clipboard) {
            addAddressToClipboard(player, mainHandItem);
            return class_1269.field_5812;
        }

        openHandledScreen((class_3222) player);
        return class_1269.field_5812;
    }

    protected void onOpenedManually() {
    }

    private void addAddressToClipboard(class_1657 player, class_1799 mainHandItem) {
        if (addressFilter == null || addressFilter.isBlank())
            return;

        ClipboardContent clipboard = mainHandItem.method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY);
        List<List<ClipboardEntry>> list = ClipboardEntry.readAll(clipboard);
        for (List<ClipboardEntry> page : list) {
            for (ClipboardEntry entry : page) {
                String existing = entry.text.getString();
                if (existing.equals("#" + addressFilter) || existing.equals("# " + addressFilter))
                    return;
            }
        }

        List<ClipboardEntry> page = null;

        for (List<ClipboardEntry> freePage : list) {
            if (freePage.size() > 11)
                continue;
            page = freePage;
            break;
        }

        if (page == null) {
            page = new ArrayList<>();
            list.add(page);
        }

        page.add(new ClipboardEntry(false, class_2561.method_43470("#" + addressFilter)));
        player.method_7353(class_2561.method_43469("create.clipboard.address_added", addressFilter), true);

        clipboard = clipboard.setPages(list).setType(ClipboardType.WRITTEN);
        mainHandItem.method_57379(AllDataComponents.CLIPBOARD_CONTENT, clipboard);
    }

    @Override
    public MenuBase<?> createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        extraData.method_10807(field_11867);
        return new PackagePortMenu(pContainerId, pPlayerInventory, this);
    }

    public int getComparatorOutput() {
        if (inventory == null) {
            return 0;
        } else {
            int itemsFound = 0;
            float proportion = 0.0F;

            int size = inventory.method_5439();
            for (int j = 0; j < size; ++j) {
                class_1799 itemstack = inventory.method_5438(j);

                if (!itemstack.method_7960()) {
                    proportion += (float) itemstack.method_7947() / (float) itemstack.method_7914();
                    ++itemsFound;
                }
            }

            proportion = proportion / (float) size;
            return class_3532.method_15375(proportion * 14.0F) + (itemsFound > 0 ? 1 : 0);
        }
    }

    public class PackagePortInventory implements SidedItemInventory {
        public static final int[] SLOTS = SlotRangeCache.get(18);
        public final class_2371<class_1799> stacks = class_2371.method_10213(18, class_1799.field_8037);
        private boolean receive = true;

        @Override
        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            String filterString = getFilterString();
            if (receive) {
                return filterString != null && PackageItem.matchAddress(stack, filterString);
            } else {
                return filterString == null || !PackageItem.matchAddress(stack, filterString);
            }
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            String filterString = getFilterString();
            if (receive) {
                return filterString == null || !PackageItem.matchAddress(stack, filterString);
            } else {
                return filterString != null && PackageItem.matchAddress(stack, filterString);
            }
        }

        public void receiveMode() {
            this.receive = true;
        }

        public void sendMode() {
            this.receive = false;
        }

        @Override
        public boolean method_5437(int slot, class_1799 stack) {
            return PackageItem.isPackage(stack);
        }

        @Override
        public int method_5439() {
            return 18;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= 18) {
                return class_1799.field_8037;
            }
            return stacks.get(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 18) {
                return;
            }
            stacks.set(slot, stack);
        }

        @Override
        public void method_5431() {
            notifyUpdate();
        }

        public void write(class_11372 view) {
            class_11372.class_11373<class_11343> list = view.method_71467("Inventory", class_11343.field_60354);
            for (int i = 0; i < 18; i++) {
                class_1799 stack = stacks.get(i);
                if (stack.method_7960()) {
                    continue;
                }
                list.method_71484(new class_11343(i, stack));
            }
        }

        public void read(class_11368 view) {
            class_11368.class_11369<class_11343> list = view.method_71437("Inventory", class_11343.field_60354);
            for (int i = 0; i < 18; i++) {
                stacks.set(i, class_1799.field_8037);
            }
            for (class_11343 slot : list) {
                stacks.set(slot.comp_4211(), slot.comp_4212());
            }
        }
    }
}
