package com.zurrtum.create.content.logistics.packagerLink;

import com.mojang.serialization.Codec;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.server.MinecraftServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LogisticsNetworkSavedData extends class_18 {
    public static final Codec<LogisticsNetworkSavedData> CODEC = Codec.list(LogisticsNetwork.CODEC)
        .xmap(LogisticsNetworkSavedData::createMap, LogisticsNetworkSavedData::toList)
        .xmap(LogisticsNetworkSavedData::new, LogisticsNetworkSavedData::getLogisticsNetworks);
    private static final class_10741<LogisticsNetworkSavedData> TYPE = new class_10741<>(
        "create_logistics",
        LogisticsNetworkSavedData::new,
        CODEC,
        null
    );

    private final Map<UUID, LogisticsNetwork> logisticsNetworks;

    public Map<UUID, LogisticsNetwork> getLogisticsNetworks() {
        return logisticsNetworks;
    }

    private LogisticsNetworkSavedData() {
        logisticsNetworks = new HashMap<>();
    }

    private LogisticsNetworkSavedData(Map<UUID, LogisticsNetwork> logisticsNetworks) {
        this.logisticsNetworks = logisticsNetworks;
    }

    private static Map<UUID, LogisticsNetwork> createMap(List<LogisticsNetwork> list) {
        Map<UUID, LogisticsNetwork> logisticsNetworks = new HashMap<>();
        list.forEach(network -> logisticsNetworks.put(network.id, network));
        return logisticsNetworks;
    }

    private static List<LogisticsNetwork> toList(Map<UUID, LogisticsNetwork> logisticsNetworks) {
        return logisticsNetworks.values().stream().toList();
    }

    public static LogisticsNetworkSavedData load(MinecraftServer server) {
        return server.method_30002().method_17983().method_17924(TYPE);
    }
}
