package com.zurrtum.create.content.logistics.redstoneRequester;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_8235;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9904;
import net.minecraft.util.*;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

public class RedstoneRequesterBlock extends class_2248 implements IBE<RedstoneRequesterBlockEntity>, IWrenchable, WeakPowerControlBlock {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<class_2351> AXIS = class_2741.field_12529;

    public RedstoneRequesterBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED, AXIS));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        if (stateForPlacement == null)
            return null;
        return stateForPlacement.method_11657(AXIS, pContext.method_8042().method_10166())
            .method_11657(POWERED, pContext.method_8045().method_49803(pContext.method_8037()));
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pBlockState, class_1937 pLevel, class_2338 pPos) {
        RedstoneRequesterBlockEntity req = getBlockEntity(pLevel, pPos);
        return req != null && req.lastRequestSucceeded ? 15 : 0;
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return onBlockEntityUse(level, pos, be -> be.use(player));
    }

    public static void programRequester(class_3222 player, StockTickerBlockEntity be, PackageOrderWithCrafts order, String address) {
        class_1799 stack = player.method_6047();
        boolean isRequester = stack.method_31574(AllItems.REDSTONE_REQUESTER);
        boolean isShopCloth = stack.method_31573(AllItemTags.TABLE_CLOTHS);
        if (!isRequester && !isShopCloth)
            return;

        String targetDim = player.method_51469().method_27983().method_29177().toString();
        AutoRequestData autoRequestData = new AutoRequestData(order, address, be.method_11016(), targetDim, false);

        autoRequestData.writeToItem(class_2338.field_10980, stack);

        if (isRequester) {
            class_2487 beTag = stack.method_58695(class_9334.field_49611, class_9279.field_49302).method_57461();
            beTag.method_67494("Freq", class_4844.field_25122, be.behaviour.freqId);
            beTag.method_67494("id", CreateCodecs.BLOCK_ENTITY_TYPE_CODEC, AllBlockEntityTypes.REDSTONE_REQUESTER);
            stack.method_57379(class_9334.field_49611, class_9279.method_57456(beTag));
        }

        player.method_6122(class_1268.field_5808, stack);
    }

    public static void appendRequesterTooltip(class_1799 pStack, Consumer<class_2561> pTooltip) {
        if (!pStack.method_57826(AllDataComponents.AUTO_REQUEST_DATA))
            return;

        AutoRequestData data = pStack.method_58694(AllDataComponents.AUTO_REQUEST_DATA);

        //noinspection DataFlowIssue
        for (BigItemStack entry : data.encodedRequest().stacks()) {
            pTooltip.accept(entry.stack.method_7964().method_27661().method_27693(" x").method_27693(String.valueOf(entry.count)).method_27692(class_124.field_1080));
        }

        pTooltip.accept(class_2561.method_43471("create.logistically_linked.tooltip_clear").method_27692(class_124.field_1063));
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 requesterPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        class_1657 player = pPlacer instanceof class_1657 ? (class_1657) pPlacer : null;
        withBlockEntityDo(
            pLevel, requesterPos, rrbe -> {
                AutoRequestData data = AutoRequestData.readFromItem(pLevel, player, requesterPos, pStack);
                if (data == null)
                    return;
                rrbe.encodedRequest = data.encodedRequest();
                rrbe.encodedTargetAdress = data.encodedTargetAddress();
            }
        );
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pNeighborBlock,
        @Nullable class_9904 wireOrientation,
        boolean pMovedByPiston
    ) {
        if (pLevel.method_8608())
            return;
        pLevel.method_8501(pPos, pState.method_11657(POWERED, pLevel.method_49803(pPos)));
        withBlockEntityDo(pLevel, pPos, RedstoneRequesterBlockEntity::onRedstonePowerChanged);
    }

    @Override
    public Class<RedstoneRequesterBlockEntity> getBlockEntityClass() {
        return RedstoneRequesterBlockEntity.class;
    }

    @Override
    public class_2591<? extends RedstoneRequesterBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.REDSTONE_REQUESTER;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return pState.method_11657(AXIS, pRotation.method_10503(class_2350.method_10156(class_2352.field_11056, pState.method_11654(AXIS))).method_10166());
    }

}
