package com.zurrtum.create.content.logistics.stockTicker;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity.StockTickerInventory;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class StockTickerBlock extends class_2383 implements IBE<StockTickerBlockEntity>, IWrenchable, ItemInventoryProvider<StockTickerBlockEntity> {

    public static final MapCodec<StockTickerBlock> CODEC = method_54094(StockTickerBlock::new);

    public StockTickerBlock(class_2251 pProperties) {
        super(pProperties);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, StockTickerBlockEntity blockEntity, class_2350 context) {
        return blockEntity.receivedPayments;
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2350 facing = pContext.method_8042().method_10153();
        boolean reverse = pContext.method_8036() != null && pContext.method_8036().method_5715();
        return super.method_9605(pContext).method_11657(field_11177, reverse ? facing.method_10153() : facing);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(field_11177));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (stack.method_7909() instanceof LogisticallyLinkedBlockItem)
            return class_1269.field_52423;

        return onBlockEntityUseItemOn(
            level, pos, stbe -> {
                if (!stbe.behaviour.mayInteractMessage(player))
                    return class_1269.field_5812;

                if (!level.method_8608()) {
                    StockTickerInventory inventory = stbe.receivedPayments;
                    class_1661 playerInventory = player.method_31548();
                    boolean anySuccess = false;
                    for (int i = 0, size = inventory.method_5439(); i < size; i++) {
                        class_1799 target = inventory.method_5438(i);
                        if (target.method_7960()) {
                            continue;
                        }
                        inventory.method_5447(i, class_1799.field_8037);
                        playerInventory.method_7398(target);
                        anySuccess = true;
                    }
                    if (anySuccess) {
                        inventory.method_5431();
                        player.method_37908().method_8396(
                            null,
                            player.method_24515(),
                            class_3417.field_15197,
                            class_3419.field_15248,
                            .2f,
                            1f + player.method_37908().field_9229.method_43057()
                        );
                        return class_1269.field_5812;
                    }
                }

                if (player instanceof class_3222 sp) {
                    if (stbe.isKeeperPresent())
                        MenuProvider.openHandledScreen(sp, stbe::createCategoryMenu);
                    else
                        player.method_7353(class_2561.method_43471("create.stock_ticker.keeper_missing"), true);
                }

                return class_1269.field_5812;
            }
        );
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.STOCK_TICKER;
    }

    @Override
    public Class<StockTickerBlockEntity> getBlockEntityClass() {
        return StockTickerBlockEntity.class;
    }

    @Override
    public class_2591<? extends StockTickerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STOCK_TICKER;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}
