package com.zurrtum.create.content.logistics.tunnel;

import com.zurrtum.create.catnip.math.VoxelShaper;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class BeltTunnelShapes {

    private static final class_265 block = class_2248.method_9541(0, -5, 0, 16, 16, 16);

    private static final VoxelShaper opening = VoxelShaper.forHorizontal(class_2248.method_9541(2, -5, 14, 14, 10, 16), class_2350.field_11035);

    private static final VoxelShaper STRAIGHT = VoxelShaper.forHorizontalAxis(
        class_259.method_1072(
            block,
            class_259.method_1084(opening.get(class_2350.field_11035), opening.get(class_2350.field_11043)),
            class_247.field_16892
        ), class_2351.field_11051
    ),

    TEE = VoxelShaper.forHorizontal(
        class_259.method_1072(
            block,
            class_259.method_17786(opening.get(class_2350.field_11043), opening.get(class_2350.field_11039), opening.get(class_2350.field_11034)),
            class_247.field_16892
        ), class_2350.field_11035
    );

    private static final class_265 CROSS = class_259.method_1072(
        block,
        class_259.method_17786(opening.get(class_2350.field_11035), opening.get(class_2350.field_11043), opening.get(class_2350.field_11039), opening.get(class_2350.field_11034)),
        class_247.field_16892
    );

    public static class_265 getShape(class_2680 state) {
        BeltTunnelBlock.Shape shape = state.method_11654(BeltTunnelBlock.SHAPE);
        class_2350.class_2351 axis = state.method_11654(BeltTunnelBlock.HORIZONTAL_AXIS);

        if (shape == BeltTunnelBlock.Shape.CROSS)
            return CROSS;

        if (BeltTunnelBlock.isStraight(state))
            return STRAIGHT.get(axis);

        if (shape == BeltTunnelBlock.Shape.T_LEFT)
            return TEE.get(axis == class_2350.class_2351.field_11051 ? class_2350.field_11034 : class_2350.field_11043);

        if (shape == BeltTunnelBlock.Shape.T_RIGHT)
            return TEE.get(axis == class_2350.class_2351.field_11051 ? class_2350.field_11039 : class_2350.field_11035);

        // something went wrong
        return class_259.method_1077();
    }
}
