package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import org.apache.commons.lang3.function.TriFunction;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_9695;

public record BasinInput(
    ServerFilteringBehaviour filter, HeatLevel heat, FluidInventory fluids, class_1263 items,
    TriFunction<List<class_1799>, List<FluidStack>, Boolean, Boolean> callback
) implements class_9695 {
    public BasinInput(BasinBlockEntity basin) {
        this(basin.getFilter(), basin.getHeatLevel(), basin.fluidCapability, basin.itemCapability, basin::acceptOutputs);
    }

    public boolean acceptOutputs(List<class_1799> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        return callback.apply(outputItems, outputFluids, simulate);
    }

    @Override
    public class_1799 method_59984(int slot) {
        return class_1799.field_8037;
    }

    @Override
    public int method_59983() {
        return 0;
    }

    @Override
    public boolean method_59987() {
        return false;
    }
}
