package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class FactoryGaugeDisplaySource extends ValueListDisplaySource {

    @Override
    protected Stream<IntAttached<class_5250>> provideEntries(DisplayLinkContext context, int maxRows) {
        List<FactoryPanelPosition> panels = context.blockEntity().factoryPanelSupport.getLinkedPanels();
        if (panels.isEmpty())
            return Stream.empty();
        return panels.stream().map(fpp -> createEntry(context.level(), fpp))
            //			.sorted(IntAttached.comparator())
            .filter(Objects::nonNull).limit(maxRows);
    }

    @Nullable
    public IntAttached<class_5250> createEntry(class_1937 level, FactoryPanelPosition pos) {
        ServerFactoryPanelBehaviour panel = ServerFactoryPanelBehaviour.at(level, pos);
        if (panel == null)
            return null;

        class_1799 filter = panel.getFilter();

        int demand = panel.getAmount() * (panel.upTo ? 1 : filter.method_7914());
        String s = " ";

        if (demand != 0) {
            int promised = panel.getPromised();
            if (panel.satisfied)
                s = "✔";
            else if (promised != 0)
                s = "↑";
            else
                s = "▪";
        }

        return IntAttached.with(
            panel.getLevelInStorage(),
            class_2561.method_43470(s + " ").method_54663(panel.getIngredientStatusColor()).method_10852(filter.method_7964().method_27662().method_27692(class_124.field_1070))
        );
    }

    @Override
    protected String getTranslationKey() {
        return "gauge_status";
    }

    @Override
    protected boolean valueFirst() {
        return true;
    }

}
