package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class RedstoneLinkBlockEntity extends SmartBlockEntity {

    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private ServerLinkBehaviour link;
    private boolean transmitter;

    public FactoryPanelSupportBehaviour panelSupport;

    public RedstoneLinkBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REDSTONE_LINK, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(panelSupport = new FactoryPanelSupportBehaviour(
            this,
            () -> link != null && link.isListening(),
            () -> receivedSignal > 0,
            () -> AllBlocks.REDSTONE_LINK.updateTransmittedSignal(method_11010(), field_11863, field_11867)
        ));
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
        createLink();
        behaviours.add(link);
    }

    protected void createLink() {
        link = transmitter ? ServerLinkBehaviour.transmitter(this, this::getSignal) : ServerLinkBehaviour.receiver(this, this::setSignal);
    }

    public int getSignal() {
        return transmittedSignal;
    }

    public void setSignal(int power) {
        if (receivedSignal != power)
            receivedSignalChanged = true;
        receivedSignal = power;
    }

    public void transmit(int strength) {
        transmittedSignal = strength;
        if (link != null)
            link.notifySignalChange();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Transmitter", transmitter);
        view.method_71465("Receive", getReceivedSignal());
        view.method_71472("ReceivedChanged", receivedSignalChanged);
        view.method_71465("Transmit", transmittedSignal);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        transmitter = view.method_71433("Transmitter", false);
        super.read(view, clientPacket);

        receivedSignal = view.method_71424("Receive", 0);
        receivedSignalChanged = view.method_71433("ReceivedChanged", false);
        if (field_11863 == null || field_11863.field_9236 || !link.newPosition)
            transmittedSignal = view.method_71424("Transmit", 0);
    }

    @Override
    public void tick() {
        super.tick();

        if (isTransmitterBlock() != transmitter) {
            transmitter = isTransmitterBlock();
            ServerLinkBehaviour prevlink = link;
            removeBehaviour(ServerLinkBehaviour.TYPE);
            createLink();
            link.copyItemsFrom(prevlink);
            attachBehaviourLate(link);
        }

        if (transmitter)
            return;
        if (field_11863.field_9236)
            return;

        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.REDSTONE_LINK))
            return;

        if ((getReceivedSignal() > 0) != blockState.method_11654(RedstoneLinkBlock.POWERED)) {
            receivedSignalChanged = true;
            field_11863.method_8501(field_11867, blockState.method_28493(RedstoneLinkBlock.POWERED));
        }

        if (receivedSignalChanged) {
            updateSelfAndAttached(blockState);
        }
    }

    @Override
    public void remove() {
        super.remove();

        updateSelfAndAttached(method_11010());
    }

    public void updateSelfAndAttached(class_2680 blockState) {
        class_2350 attachedFace = blockState.method_11654(RedstoneLinkBlock.field_10927).method_10153();
        class_2338 attachedPos = field_11867.method_10093(attachedFace);
        field_11863.method_8408(field_11867, field_11863.method_8320(field_11867).method_26204());
        field_11863.method_8408(attachedPos, field_11863.method_8320(attachedPos).method_26204());
        receivedSignalChanged = false;
        panelSupport.notifyPanels();
    }

    protected Boolean isTransmitterBlock() {
        return !method_11010().method_11654(RedstoneLinkBlock.RECEIVER);
    }

    public int getReceivedSignal() {
        return receivedSignal;
    }

}
