package com.zurrtum.create.content.redstone.smartObserver;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection.Flow;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase.InterfaceProvider;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SmartObserverBlockEntity extends SmartBlockEntity {

    private static final int DEFAULT_DELAY = 6;
    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;

    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private boolean sustainSignal;

    public int turnOffTicks = 0;

    public SmartObserverBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SMART_OBSERVER, pos, state);
        setLazyTickRate(20);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(filtering = new ServerFilteringBehaviour(this).withCallback($ -> invVersionTracker.reset()));
        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));

        InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));

        behaviours.add(observedInventory = new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness());
        behaviours.add(observedTank = new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness());
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.method_8608())
            return;

        class_2680 state = method_11010();
        if (turnOffTicks > 0) {
            turnOffTicks--;
            if (turnOffTicks == 0)
                field_11863.method_64310(field_11867, state.method_26204(), 1);
        }

        if (!isActive())
            return;

        class_2338 targetPos = field_11867.method_10093(SmartObserverBlock.getTargetDirection(state));
        class_2248 block = field_11863.method_8320(targetPos).method_26204();

        if (!filtering.getFilter().method_7960() && block.method_8389() != null && filtering.test(new class_1799(block))) {
            activate(3);
            return;
        }

        // Detect items on belt
        TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get(field_11863, targetPos, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.handleCenteredProcessingOnAllItems(
                .45f, stack -> {
                    if (!filtering.test(stack.stack) || turnOffTicks == 6)
                        return TransportedResult.doNothing();
                    activate();
                    return TransportedResult.doNothing();
                }
            );
            return;
        }

        // Detect fluids in pipe
        FluidTransportBehaviour fluidBehaviour = BlockEntityBehaviour.get(field_11863, targetPos, FluidTransportBehaviour.TYPE);
        if (fluidBehaviour != null) {
            for (class_2350 side : Iterate.directions) {
                Flow flow = fluidBehaviour.getFlow(side);
                if (flow == null || !flow.inbound || !flow.complete)
                    continue;
                if (!filtering.test(flow.fluid))
                    continue;
                activate();
                return;
            }
            return;
        }

        // Detect packages looping on a chain conveyor
        if (field_11863.method_8321(targetPos) instanceof ChainConveyorBlockEntity ccbe) {
            for (ChainConveyorPackage box : ccbe.getLoopingPackages())
                if (filtering.test(box.item)) {
                    activate();
                    return;
                }
            return;
        }

        if (observedInventory.hasInventory()) {
            boolean skipInv = invVersionTracker.stillWaiting(observedInventory);
            invVersionTracker.awaitNewVersion(observedInventory);

            if (skipInv && sustainSignal)
                turnOffTicks = DEFAULT_DELAY;

            if (!skipInv) {
                sustainSignal = false;
                if (!observedInventory.simulate().extract().method_7960()) {
                    sustainSignal = true;
                    activate();
                    return;
                }
            }
        }

        if (!observedTank.simulate().extractAny().isEmpty()) {
            activate();
        }
    }

    public void activate() {
        activate(DEFAULT_DELAY);
    }

    public void activate(int ticks) {
        class_2680 state = method_11010();
        turnOffTicks = ticks;
        if (state.method_11654(SmartObserverBlock.POWERED))
            return;
        field_11863.method_8501(field_11867, state.method_11657(SmartObserverBlock.POWERED, true));
        field_11863.method_8452(field_11867, state.method_26204(), null);
    }

    private boolean isActive() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("TurnOff", turnOffTicks);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        turnOffTicks = view.method_71424("TurnOff", 0);
    }

}
