package com.zurrtum.create.content.trains.display;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.util.math.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FlapDisplayBlockEntity extends KineticBlockEntity implements DisplayHolder {

    public List<FlapDisplayLayout> lines;
    public boolean isController;
    public boolean isRunning;
    public int xSize, ySize;
    public class_1767[] colour;
    public boolean[] glowingLines;
    public boolean[] manualLines;
    private class_2487 displayLink;

    public FlapDisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FLAP_DISPLAY, pos, state);
        setLazyTickRate(10);
        isController = false;
        xSize = 1;
        ySize = 1;
        colour = new class_1767[2];
        manualLines = new boolean[2];
        glowingLines = new boolean[2];
    }

    @Override
    public class_2487 getDisplayLinkData() {
        return displayLink;
    }

    @Override
    public void setDisplayLinkData(class_2487 data) {
        displayLink = data;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        updateControllerStatus();
    }

    public void updateControllerStatus() {
        if (field_11863.field_9236)
            return;

        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock))
            return;

        class_2350 leftDirection = blockState.method_11654(FlapDisplayBlock.HORIZONTAL_FACING).method_10170();
        boolean shouldBeController = !blockState.method_11654(FlapDisplayBlock.UP) && field_11863.method_8320(field_11867.method_10093(leftDirection)) != blockState;

        int newXSize = 1;
        int newYSize = 1;

        if (shouldBeController) {
            for (int xOffset = 1; xOffset < 32; xOffset++) {
                if (field_11863.method_8320(field_11867.method_10079(leftDirection.method_10153(), xOffset)) != blockState)
                    break;
                newXSize++;
            }
            for (int yOffset = 0; yOffset < 32; yOffset++) {
                if (!field_11863.method_8320(field_11867.method_10079(class_2350.field_11033, yOffset)).method_61767(FlapDisplayBlock.DOWN, false))
                    break;
                newYSize++;
            }
        }

        if (isController == shouldBeController && newXSize == xSize && newYSize == ySize)
            return;

        isController = shouldBeController;
        xSize = newXSize;
        ySize = newYSize;
        colour = Arrays.copyOf(colour, ySize * 2);
        glowingLines = Arrays.copyOf(glowingLines, ySize * 2);
        manualLines = new boolean[ySize * 2];
        lines = null;
        sendData();
    }

    @Override
    public void tick() {
        super.tick();
        isRunning = super.isSpeedRequirementFulfilled();
        if ((!field_11863.field_9236 || !isRunning) && !isVirtual())
            return;
        int activeFlaps = 0;
        boolean instant = Math.abs(getSpeed()) > 128;
        for (FlapDisplayLayout line : lines)
            for (FlapDisplaySection section : line.getSections())
                activeFlaps += section.tick(instant, field_11863.field_9229);
        if (activeFlaps == 0)
            return;

        float volume = class_3532.method_15363(activeFlaps / 20f, 0.25f, 1.5f);
        float bgVolume = class_3532.method_15363(activeFlaps / 40f, 0.25f, 1f);
        class_2338 middle = field_11867.method_10079(getDirection().method_10170(), xSize / 2).method_10079(class_2350.field_11033, ySize / 2);
        AllSoundEvents.SCROLL_VALUE.playAt(field_11863, middle, volume, 0.56f, false);
        field_11863.method_8486(
            middle.method_10263(),
            middle.method_10264(),
            middle.method_10260(),
            class_3417.field_26951,
            class_3419.field_15245,
            .35f * bgVolume,
            1.95f,
            false
        );
    }

    @Override
    public boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isSpeedRequirementFulfilled() {
        return isRunning;
    }

    public void applyTextManually(int lineIndex, class_2561 componentText) {
        List<FlapDisplayLayout> lines = getLines();
        if (lineIndex >= lines.size())
            return;

        FlapDisplayLayout layout = lines.get(lineIndex);
        if (!layout.isLayout("Default"))
            layout.loadDefault(getMaxCharCount());
        List<FlapDisplaySection> sections = layout.getSections();

        FlapDisplaySection flapDisplaySection = sections.getFirst();
        if (componentText == null) {
            manualLines[lineIndex] = false;
            flapDisplaySection.setText(class_5244.field_39003);
            notifyUpdate();
            return;
        }

        manualLines[lineIndex] = true;
        class_2561 text = isVirtual() ? componentText : DynamicComponent.parseCustomText(field_11863, field_11867, componentText);
        flapDisplaySection.setText(text);
        if (isVirtual())
            flapDisplaySection.refresh(true);
        else
            notifyUpdate();
    }

    public void setColour(int lineIndex, class_1767 color) {
        colour[lineIndex] = color == class_1767.field_7952 ? null : color;
        notifyUpdate();
    }

    public void setGlowing(int lineIndex) {
        glowingLines[lineIndex] = true;
        notifyUpdate();
    }

    public List<FlapDisplayLayout> getLines() {
        if (lines == null)
            initDefaultSections();
        return lines;
    }

    public void initDefaultSections() {
        lines = new ArrayList<>();
        for (int i = 0; i < ySize * 2; i++)
            lines.add(new FlapDisplayLayout(getMaxCharCount()));
    }

    public int getMaxCharCount() {
        return getMaxCharCount(0);
    }

    public int getMaxCharCount(int gaps) {
        return (int) ((xSize * 16f - 2f - 4f * gaps) / 3.5f);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        writeDisplayLink(view);

        view.method_71472("Controller", isController);
        view.method_71465("XSize", xSize);
        view.method_71465("YSize", ySize);

        for (int j = 0; j < manualLines.length; j++)
            if (manualLines[j])
                view.method_71472("CustomLine" + j, true);

        for (int j = 0; j < glowingLines.length; j++)
            if (glowingLines[j])
                view.method_71472("GlowingLine" + j, true);

        for (int j = 0; j < colour.length; j++)
            if (colour[j] != null)
                view.method_71468("Dye" + j, class_1767.field_41600, colour[j]);

        List<FlapDisplayLayout> lines = getLines();
        for (int i = 0; i < lines.size(); i++)
            lines.get(i).write(view.method_71461("Display" + i));
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        readDisplayLink(view);
        boolean wasActive = isController;
        int prevX = xSize;
        int prevY = ySize;

        isController = view.method_71433("Controller", false);
        xSize = view.method_71424("XSize", 0);
        ySize = view.method_71424("YSize", 0);

        manualLines = new boolean[ySize * 2];
        for (int i = 0; i < ySize * 2; i++)
            manualLines[i] = view.method_71433("CustomLine" + i, false);

        glowingLines = new boolean[ySize * 2];
        for (int i = 0; i < ySize * 2; i++)
            glowingLines[i] = view.method_71433("GlowingLine" + i, false);

        colour = new class_1767[ySize * 2];
        for (int i = 0; i < ySize * 2; i++)
            colour[i] = view.method_71426("Dye" + i, class_1767.field_41600).orElse(null);

        if (clientPacket && wasActive != isController || prevX != xSize || prevY != ySize) {
            invalidateRenderBoundingBox();
            lines = null;
        }

        List<FlapDisplayLayout> lines = getLines();
        for (int i = 0; i < lines.size(); i++)
            lines.get(i).read(view.method_71434("Display" + i));
    }

    public int getLineIndexAt(double yCoord) {
        return (int) class_3532.method_15350(Math.floor(2 * (field_11867.method_10264() - yCoord + 1)), 0, ySize * 2);
    }

    public FlapDisplayBlockEntity getController() {
        if (isController)
            return this;

        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock))
            return null;

        class_2338.class_2339 pos = method_11016().method_25503();
        class_2350 side = blockState.method_11654(FlapDisplayBlock.HORIZONTAL_FACING).method_10170();

        for (int i = 0; i < 64; i++) {
            class_2680 other = field_11863.method_8320(pos);

            if (other.method_61767(FlapDisplayBlock.UP, false)) {
                pos.method_10098(class_2350.field_11036);
                continue;
            }

            if (!field_11863.method_8320(pos.method_10093(side)).method_61767(FlapDisplayBlock.UP, true)) {
                pos.method_10098(side);
                continue;
            }

            class_2586 found = field_11863.method_8321(pos);
            if (found instanceof FlapDisplayBlockEntity flap && flap.isController)
                return flap;

            break;
        }

        return null;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        class_238 aabb = new class_238(field_11867);
        if (!isController)
            return aabb;
        class_2382 normal = getDirection().method_10170().method_62675();
        return aabb.method_1012(normal.method_10263() * xSize, -ySize, normal.method_10260() * xSize);
    }

    public class_2350 getDirection() {
        return method_11010().method_61767(FlapDisplayBlock.HORIZONTAL_FACING, class_2350.field_11035).method_10153();
    }

    public boolean isLineGlowing(int line) {
        return glowingLines[line];
    }

}
