package com.zurrtum.create.content.trains.entity;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3709;

public class ArrivalSoundQueue {
    public int offset;
    int min, max;
    Multimap<Integer, class_2338> sources;

    public ArrivalSoundQueue() {
        sources = Multimaps.newMultimap(new HashMap<>(), ArrayList::new);
        min = Integer.MAX_VALUE;
        max = Integer.MIN_VALUE;
    }

    @Nullable
    public Integer firstTick() {
        return sources.isEmpty() ? null : min + offset;
    }

    @Nullable
    public Integer lastTick() {
        return sources.isEmpty() ? null : max + offset;
    }

    public boolean tick(CarriageContraptionEntity entity, int tick, boolean backwards) {
        tick = tick - offset;
        if (!sources.containsKey(tick))
            return backwards ? tick > min : tick < max;
        Contraption contraption = entity.getContraption();
        for (class_2338 blockPos : sources.get(tick))
            play(entity, contraption.getBlocks().get(blockPos));
        return backwards ? tick > min : tick < max;
    }

    public Pair<Boolean, Integer> getFirstWhistle(CarriageContraptionEntity entity) {
        Integer firstTick = firstTick();
        Integer lastTick = lastTick();
        if (firstTick == null || lastTick == null || firstTick > lastTick)
            return null;
        for (int i = firstTick; i <= lastTick; i++) {
            if (!sources.containsKey(i - offset))
                continue;
            Contraption contraption = entity.getContraption();
            for (class_2338 blockPos : sources.get(i - offset)) {
                class_3501 info = contraption.getBlocks().get(blockPos);
                if (info == null)
                    continue;
                class_2680 state = info.comp_1342();
                if (state.method_26204() instanceof WhistleBlock && info.comp_1343() != null) {
                    int pitch = info.comp_1343().method_68083("Pitch", 0);
                    WhistleSize size = state.method_11654(WhistleBlock.SIZE);
                    return Pair.of(size == WhistleSize.LARGE, (size == WhistleSize.SMALL ? 12 : 0) - pitch);
                }
            }
        }
        return null;
    }

    public void write(class_11372 view) {
        class_11372 tag = view.method_71461("SoundQueue");
        tag.method_71465("Offset", offset);
        class_11372.class_11374 list = tag.method_71476("Sources");
        for (Map.Entry<Integer, class_2338> entry : sources.entries()) {
            class_11372 item = list.method_71480();
            item.method_71465("Tick", entry.getKey());
            item.method_71468("Pos", class_2338.field_25064, entry.getValue());
        }
    }

    public void read(class_11368 view) {
        class_11368 tag = view.method_71434("SoundQueue");
        offset = tag.method_71424("Offset", 0);
        class_11368.class_11370 list = tag.method_71438("Sources");
        list.forEach(item -> add(item.method_71424("Tick", 0), item.method_71426("Pos", class_2338.field_25064).orElse(class_2338.field_10980)));
    }

    public void add(int offset, class_2338 localPos) {
        sources.put(offset, localPos);
        min = Math.min(offset, min);
        max = Math.max(offset, max);
    }

    public static boolean isPlayable(class_2680 state) {
        if (state.method_26204() instanceof class_3709)
            return true;
        if (state.method_26204() instanceof class_2428)
            return true;
        return state.method_26204() instanceof WhistleBlock;
    }

    public static void play(CarriageContraptionEntity entity, class_3501 info) {
        if (info == null)
            return;
        class_2680 state = info.comp_1342();

        if (state.method_26204() instanceof class_3709) {
            if (state.method_27852(AllBlocks.HAUNTED_BELL))
                playSimple(entity, AllSoundEvents.HAUNTED_BELL_USE.getMainEvent(), 1, 1);
            else
                playSimple(entity, class_3417.field_17265, 1, 1);
        }

        if (state.method_26204() instanceof class_2428 nb) {
            float f = (float) Math.pow(2, (state.method_11654(class_2428.field_11324) - 12) / 12.0);
            playSimple(entity, state.method_11654(class_2428.field_11325).method_11886().comp_349(), 1, f);
        }

        if (state.method_26204() instanceof WhistleBlock && info.comp_1343() != null) {
            int pitch = info.comp_1343().method_68083("Pitch", 0);
            WhistleSize size = state.method_11654(WhistleBlock.SIZE);
            float f = (float) Math.pow(2, ((size == WhistleSize.SMALL ? 12 : 0) - pitch) / 12.0);
            playSimple(entity, (size == WhistleSize.LARGE ? AllSoundEvents.WHISTLE_TRAIN_LOW : AllSoundEvents.WHISTLE_TRAIN).getMainEvent(), 1, f);
            //			playSimple(entity, AllSoundEvents.WHISTLE_CHIFF.getMainEvent(), .75f,
            //				size == WhistleSize.SMALL ? f + .75f : f);
        }

    }

    private static void playSimple(CarriageContraptionEntity entity, class_3414 event, float volume, float pitch) {
        entity.method_37908().method_43129(null, entity, event, class_3419.field_15254, 5 * volume, pitch);
    }

}
