package com.zurrtum.create.content.trains.entity;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.behaviour.interaction.ConductorBlockInteractionBehavior;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.minecart.TrainCargoManager;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import org.apache.commons.lang3.tuple.Pair;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499.class_3501;

public class CarriageContraption extends Contraption {

    private class_2350 assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;

    public Couple<Boolean> blockConductors;
    public Map<class_2338, Couple<Boolean>> conductorSeats;
    public ArrivalSoundQueue soundQueue;

    protected MountedStorageManager storageProxy;

    // during assembly only
    private int bogeys;
    private boolean sidewaysControls;
    private class_2338 secondBogeyPos;
    private List<class_2338> assembledBlockConductors;

    // render
    public int portalCutoffMin;
    public int portalCutoffMax;

    static final MountedStorageManager fallbackStorage;

    static {
        fallbackStorage = new MountedStorageManager();
        fallbackStorage.initialize();
    }

    public CarriageContraption() {
        conductorSeats = new HashMap<>();
        assembledBlockConductors = new ArrayList<>();
        blockConductors = Couple.create(false, false);
        soundQueue = new ArrivalSoundQueue();
        portalCutoffMin = Integer.MIN_VALUE;
        portalCutoffMax = Integer.MAX_VALUE;
        storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        soundQueue.offset = offset;
    }

    public CarriageContraption(class_2350 assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!searchMovedStructure(world, pos, null))
            return false;
        if (blocks.size() <= 1)
            return false;
        if (bogeys == 0)
            return false;
        if (bogeys > 2)
            throw new AssemblyException(class_2561.method_43469("create.train_assembly.too_many_bogeys", bogeys));
        if (sidewaysControls)
            throw new AssemblyException(class_2561.method_43471("create.train_assembly.sideways_controls"));

        for (class_2338 blazePos : assembledBlockConductors)
            for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166()))
                if (inControl(blazePos, direction))
                    blockConductors.set(direction != assemblyDirection, true);
        for (class_2338 seatPos : getSeats())
            for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166()))
                if (inControl(seatPos, direction))
                    conductorSeats.computeIfAbsent(seatPos, p -> Couple.create(false, false)).set(direction != assemblyDirection, true);

        return true;
    }

    public boolean inControl(class_2338 pos, class_2350 direction) {
        class_2338 controlsPos = pos.method_10093(direction);
        if (!blocks.containsKey(controlsPos))
            return false;
        class_3501 info = blocks.get(controlsPos);
        if (!info.comp_1342().method_27852(AllBlocks.TRAIN_CONTROLS))
            return false;
        return info.comp_1342().method_11654(ControlsBlock.field_11177) == direction.method_10153();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        // Ensure that the entity does not hold its inventory data, because the global
        // carriage manages it instead
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager) storage;
            storage = new MountedStorageManager();
        }
        storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return false;
    }

    @Override
    protected Pair<class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);

        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate(anchor, assemblyDirection.method_10166());
            int posCoord = VecHelper.getCoordinate(pos, assemblyDirection.method_10166());
            soundQueue.add((posCoord - anchorCoord) * assemblyDirection.method_10171().method_10181(), toLocalPos(pos));
        }

        if (blockState.method_26204() instanceof AbstractBogeyBlock<?>) {
            bogeys++;
            if (bogeys == 2)
                secondBogeyPos = pos;
        }

        MovingInteractionBehaviour behaviour = MovingInteractionBehaviour.REGISTRY.get(blockState);
        if (behaviour instanceof ConductorBlockInteractionBehavior conductor && conductor.isValidConductor(blockState)) {
            assembledBlockConductors.add(toLocalPos(pos));
        }

        if (blockState.method_27852(AllBlocks.TRAIN_CONTROLS)) {
            class_2350 facing = blockState.method_11654(ControlsBlock.field_11177);
            if (facing.method_10166() != assemblyDirection.method_10166())
                sidewaysControls = true;
            else {
                boolean forwards = facing == assemblyDirection;
                if (forwards)
                    forwardControls = true;
                else
                    backwardControls = true;
            }
        }

        return super.capture(world, pos);
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71468("AssemblyDirection", class_2350.field_29502, getAssemblyDirection());
        view.method_71472("FrontControls", forwardControls);
        view.method_71472("BackControls", backwardControls);
        view.method_71472("FrontBlazeConductor", blockConductors.getFirst());
        view.method_71472("BackBlazeConductor", blockConductors.getSecond());
        class_11372.class_11374 list = view.method_71476("ConductorSeats");
        for (Map.Entry<class_2338, Couple<Boolean>> entry : conductorSeats.entrySet()) {
            class_11372 item = list.method_71480();
            item.method_71468("Pos", class_2338.field_25064, entry.getKey());
            Couple<Boolean> couple = entry.getValue();
            item.method_71472("Forward", couple.getFirst());
            item.method_71472("Backward", couple.getSecond());
        }
        soundQueue.write(view);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        assemblyDirection = view.method_71426("AssemblyDirection", class_2350.field_29502).orElse(class_2350.field_11033);
        forwardControls = view.method_71433("FrontControls", false);
        backwardControls = view.method_71433("BackControls", false);
        blockConductors = Couple.create(view.method_71433("FrontBlazeConductor", false), view.method_71433("BackBlazeConductor", false));
        conductorSeats.clear();
        view.method_71438("ConductorSeats").forEach(item -> {
            conductorSeats.put(
                item.method_71426("Pos", class_2338.field_25064).orElse(class_2338.field_10980),
                Couple.create(item.method_71433("Forward", false), item.method_71433("Backward", false))
            );
        });
        soundQueue.read(view);
        super.read(world, view, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return false;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.CARRIAGE;
    }

    public class_2350 getAssemblyDirection() {
        return assemblyDirection;
    }

    public boolean hasForwardControls() {
        return forwardControls;
    }

    public boolean hasBackwardControls() {
        return backwardControls;
    }

    public class_2338 getSecondBogeyPos() {
        return secondBogeyPos;
    }

    @Override
    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        if (notInPortal())
            return super.getSimplifiedEntityColliders();
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(class_2338 localPos) {
        if (notInPortal())
            return super.isHiddenInPortal(localPos);
        class_2350 facing = assemblyDirection;
        class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return !withinVisible(coord) || atSeam(coord);
    }

    public boolean isHiddenInPortal(int posAlongMovementAxis) {
        if (notInPortal())
            return false;
        return !withinVisible(posAlongMovementAxis) || atSeam(posAlongMovementAxis);
    }

    public boolean notInPortal() {
        return portalCutoffMin == Integer.MIN_VALUE && portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(class_2338 localPos) {
        class_2350 facing = assemblyDirection;
        class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord == portalCutoffMin || coord == portalCutoffMax;
    }

    public boolean withinVisible(class_2338 localPos) {
        class_2350 facing = assemblyDirection;
        class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return withinVisible(coord);
    }

    public boolean atSeam(int posAlongMovementAxis) {
        return posAlongMovementAxis == portalCutoffMin || posAlongMovementAxis == portalCutoffMax;
    }

    public boolean withinVisible(int posAlongMovementAxis) {
        return posAlongMovementAxis > portalCutoffMin && posAlongMovementAxis < portalCutoffMax;
    }

    @Override
    public MountedStorageManager getStorage() {
        return storageProxy == null ? fallbackStorage : storageProxy;
    }

    @Override
    public void writeStorage(class_11372 view, boolean spawnPacket) {
        if (!spawnPacket)
            return;
        if (storageProxy != null)
            storageProxy.write(view, spawnPacket);
    }

}