package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.*;
import com.zurrtum.create.catnip.data.Couple;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_4844;

public class TrackEdgeIntersection {

    public double location;
    public Couple<TrackNodeLocation> target;
    public double targetLocation;
    public UUID groupId;
    public UUID id;

    public TrackEdgeIntersection() {
        id = UUID.randomUUID();
    }

    public boolean isNear(double location) {
        return Math.abs(location - this.location) < 1 / 32f;
    }

    public boolean targets(TrackNodeLocation target1, TrackNodeLocation target2) {
        return target1.equals(target.getFirst()) && target2.equals(target.getSecond()) || target1.equals(target.getSecond()) && target2.equals(target.getFirst());
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Id", class_4844.field_25122, id);
        if (groupId != null)
            view.method_71468("GroupId", class_4844.field_25122, groupId);
        view.method_71463("Location", location);
        view.method_71463("TargetLocation", targetLocation);
        class_11372.class_11374 edge = view.method_71476("TargetEdge");
        target.getFirst().write(edge.method_71480(), dimensions);
        target.getSecond().write(edge.method_71480(), dimensions);
    }

    public static <T> DataResult<T> encode(final TrackEdgeIntersection input, final DynamicOps<T> ops, final T empty, DimensionPalette dimensions) {
        RecordBuilder<T> builder = ops.mapBuilder();
        builder.add("Id", input.id, class_4844.field_25122);
        if (input.groupId != null)
            builder.add("GroupId", input.groupId, class_4844.field_25122);
        builder.add("Location", ops.createDouble(input.location));
        builder.add("TargetLocation", ops.createDouble(input.targetLocation));
        ListBuilder<T> edge = ops.listBuilder();
        edge.add(TrackNodeLocation.encode(input.target.getFirst(), ops, empty, dimensions));
        edge.add(TrackNodeLocation.encode(input.target.getSecond(), ops, empty, dimensions));
        builder.add("TargetEdge", edge.build(empty));
        return builder.build(empty);
    }

    public static TrackEdgeIntersection read(class_11368 view, DimensionPalette dimensions) {
        TrackEdgeIntersection intersection = new TrackEdgeIntersection();
        intersection.id = view.method_71426("Id", class_4844.field_25122).orElseThrow();
        view.method_71426("GroupId", class_4844.field_25122).ifPresent(id -> intersection.groupId = id);
        intersection.location = view.method_71422("Location", 0);
        intersection.targetLocation = view.method_71422("TargetLocation", 0);
        Iterator<class_11368> edge = view.method_71438("TargetEdge").iterator();
        intersection.target = Couple.create(TrackNodeLocation.read(edge.next(), dimensions), TrackNodeLocation.read(edge.next(), dimensions));
        return intersection;
    }

    public static <T> TrackEdgeIntersection decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        TrackEdgeIntersection intersection = new TrackEdgeIntersection();
        intersection.id = class_4844.field_25122.decode(ops, map.get("Id")).getOrThrow().getFirst();
        class_4844.field_25122.decode(ops, map.get("GroupId")).result().map(Pair::getFirst).ifPresent(id -> intersection.groupId = id);
        intersection.location = ops.getNumberValue(map.get("Location"), 0).intValue();
        intersection.targetLocation = ops.getNumberValue(map.get("TargetLocation"), 0).intValue();
        intersection.target = Couple.create(null, null);
        ops.getList(map.get("TargetEdge")).getOrThrow().accept(item -> {
            TrackNodeLocation location = TrackNodeLocation.decode(ops, item, dimensions);
            if (intersection.target.getFirst() == null) {
                intersection.target.setFirst(location);
            } else {
                intersection.target.setSecond(location);
            }
        });
        return intersection;
    }

}