package com.zurrtum.create.content.trains.schedule;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class ScheduleMenu extends GhostItemMenu<class_1799> {

    public boolean slotsActive = true;
    public int targetSlotsActive = 1;

    static final int slots = 2;

    public ScheduleMenu(int id, class_1661 inv, class_1799 contentHolder) {
        super(AllMenuTypes.SCHEDULE, id, inv, contentHolder);
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(slots);
    }

    @Override
    public void method_7593(int index, int dragType, class_1713 clickType, class_1657 player) {
        if (index != playerInventory.method_67532() || clickType == class_1713.field_7795 || clickType == class_1713.field_7796)
            super.method_7593(index, dragType, clickType, player);
    }

    @Override
    protected boolean allowRepeats() {
        return true;
    }

    @Override
    protected void addSlots() {
        addPlayerSlots(46, 140);
        for (int i = 0; i < slots; i++)
            method_7621(new InactiveItemHandlerSlot(ghostInventory, i, i, 54 + 20 * i, 88));
    }

    @Override
    protected void addPlayerSlots(int x, int y) {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot)
            this.method_7621(new InactiveSlot(playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        for (int row = 0; row < 3; ++row)
            for (int col = 0; col < 9; ++col)
                this.method_7621(new InactiveSlot(playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
    }

    @Override
    protected void saveData(class_1799 contentHolder) {
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return playerInventory.method_7391() == contentHolder;
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        // prevent pick-all from taking this schedule out of its slot
        return super.method_7613(stack, slot) && !this.isInSlot(slot.field_7874);
    }

    protected boolean isInSlot(int index) {
        // Inventory has the hotbar as 0-8, but menus put the hotbar at 27-35
        return index >= 27 && index - 27 == playerInventory.method_67532();
    }

    class InactiveSlot extends class_1735 {

        public InactiveSlot(class_1263 pContainer, int pIndex, int pX, int pY) {
            super(pContainer, pIndex, pX, pY);
        }

        @Override
        public boolean method_7682() {
            return slotsActive;
        }

    }

    class InactiveItemHandlerSlot extends class_1735 {
        private final int targetIndex;

        public InactiveItemHandlerSlot(class_1263 itemHandler, int targetIndex, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.targetIndex = targetIndex;
        }

        @Override
        public boolean method_7682() {
            return slotsActive && targetIndex < targetSlotsActive;
        }
    }

}
