package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemThresholdCondition extends CargoThresholdCondition {
    public FilterItemStack stack = FilterItemStack.empty();

    public ItemThresholdCondition(class_2960 id) {
        super(id);
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        Ops operator = getOperator();
        int target = getThreshold();
        boolean stacks = inStacks();

        int foundItems = 0;
        for (Carriage carriage : train.carriages) {
            class_1263 items = carriage.storage.getAllItems();
            for (int i = 0, size = items.method_5439(); i < size; i++) {
                class_1799 stackInSlot = items.method_5438(i);
                if (!stack.test(level, stackInSlot))
                    continue;

                if (stacks)
                    foundItems += stackInSlot.method_7947() == stackInSlot.method_7914() ? 1 : 0;
                else
                    foundItems += stackInSlot.method_7947();
            }
        }

        requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(class_11372 view) {
        super.writeAdditional(view);
        view.method_71468("Item", FilterItemStack.CODEC, stack);
    }

    @Override
    protected void readAdditional(class_11368 view) {
        super.readAdditional(view);
        view.method_71426("Item", FilterItemStack.CODEC).ifPresent(stack -> this.stack = stack);
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    public boolean inStacks() {
        return intData("Measure") == 1;
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int lastDisplaySnapshot = getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1)
            return class_2561.method_43473();
        int offset = getOperator() == Ops.LESS ? -1 : getOperator() == Ops.GREATER ? 1 : 0;
        return class_2561.method_43469(
            "create.schedule.condition.threshold.status",
            lastDisplaySnapshot,
            Math.max(0, getThreshold() + offset),
            class_2561.method_43471("create.schedule.condition.threshold." + (inStacks() ? "stacks" : "items"))
        );
    }
}
