package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class StationPoweredCondition extends ScheduleWaitCondition {
    public StationPoweredCondition(class_2960 id) {
        super(id);
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        GlobalStation currentStation = train.getCurrentStation();
        if (currentStation == null)
            return false;
        class_2338 stationPos = currentStation.getBlockEntityPos();
        class_5321<class_1937> stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = level.method_8503();
        if (server == null)
            return false;
        class_3218 stationLevel = server.method_3847(stationDim);
        if (stationLevel == null || !stationLevel.method_8477(stationPos))
            return false;
        return stationLevel.method_49803(stationPos);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        return class_2561.method_43471("create.schedule.condition.powered.status");
    }
}
