package com.zurrtum.create.content.trains.station;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1263;

public class GlobalPackagePort {
    public static final Codec<GlobalPackagePort> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.STRING.fieldOf("address").forGetter(i -> i.address),
        ItemStackHandler.CODEC.fieldOf("offlineBuffer").forGetter(i -> i.offlineBuffer),
        Codec.BOOL.fieldOf("primed").forGetter(i -> i.primed),
        Codec.BOOL.fieldOf("restoring").forGetter(i -> i.restoring)
    ).apply(instance, GlobalPackagePort::new));

    public String address;
    public ItemStackHandler offlineBuffer;
    public boolean primed = false;
    private boolean restoring = false;

    public GlobalPackagePort() {
        this("", new ItemStackHandler(18), false, false);
    }

    private GlobalPackagePort(String address, ItemStackHandler offlineBuffer, boolean primed, boolean restoring) {
        this.address = address;
        this.offlineBuffer = offlineBuffer;
        this.primed = primed;
    }

    public void restoreOfflineBuffer(class_1263 inventory) {
        if (!primed)
            return;

        restoring = true;

        for (int slot = 0, size = offlineBuffer.method_5439(); slot < size; slot++) {
            inventory.method_5447(slot, offlineBuffer.method_5438(slot));
        }

        restoring = false;
        primed = false;
    }

    public void saveOfflineBuffer(class_1263 inventory) {
        /*
         * Each time restoreOfflineBuffer changes a slot, the inventory
         * calls this method. We must filter out those calls to prevent
         * overwriting later slots which haven't been restored yet and
         * to avoid unnecessary work.
         */
        if (restoring)
            return;

        // TODO: Call save method on individual slots rather than iterating
        for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
            offlineBuffer.method_5447(slot, inventory.method_5438(slot));
        }

        Create.RAILWAYS.markTracksDirty();
    }
}
