package com.zurrtum.create.foundation.block;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntityTicker;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1269;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;

public interface IBE<T extends class_2586> extends class_2343 {

    Class<T> getBlockEntityClass();

    class_2591<? extends T> getBlockEntityType();

    default void withBlockEntityDo(class_1922 world, class_2338 pos, Consumer<T> action) {
        getBlockEntityOptional(world, pos).ifPresent(action);
    }

    default class_1269 onBlockEntityUse(class_1922 world, class_2338 pos, Function<T, class_1269> action) {
        return getBlockEntityOptional(world, pos).map(action).orElse(class_1269.field_5811);
    }

    default class_1269 onBlockEntityUseItemOn(class_1922 world, class_2338 pos, Function<T, class_1269> action) {
        return getBlockEntityOptional(world, pos).map(action).orElse(class_1269.field_52423);
    }

    default Optional<T> getBlockEntityOptional(class_1922 world, class_2338 pos) {
        return Optional.ofNullable(getBlockEntity(world, pos));
    }

    @Override
    default class_2586 method_10123(class_2338 p_153215_, class_2680 p_153216_) {
        return getBlockEntityType().method_11032(p_153215_, p_153216_);
    }

    @Override
    default <S extends class_2586> class_5558<S> method_31645(class_1937 p_153212_, class_2680 p_153213_, class_2591<S> p_153214_) {
        if (SmartBlockEntity.class.isAssignableFrom(getBlockEntityClass()))
            return new SmartBlockEntityTicker<>();
        return null;
    }

    @Nullable
    @SuppressWarnings("unchecked")
    default T getBlockEntity(class_1922 worldIn, class_2338 pos) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        Class<T> expectedClass = getBlockEntityClass();

        if (blockEntity == null)
            return null;
        if (!expectedClass.isInstance(blockEntity))
            return null;

        return (T) blockEntity;
    }

}