package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class ServerFilteringBehaviour extends BlockEntityBehaviour<SmartBlockEntity> implements ValueSettingsHandleBehaviour {
    public static final BehaviourType<ServerFilteringBehaviour> TYPE = new BehaviourType<>();

    protected FilterItemStack filter;
    boolean showCount = false;
    public int count = 64;
    public boolean upTo = true;
    private Predicate<class_1799> predicate = stack -> true;
    private Consumer<class_1799> callback = stack -> {
    };
    private Supplier<Boolean> showCountPredicate = () -> showCount;
    private Supplier<Boolean> isActive = () -> true;
    boolean recipeFilter = false;
    public boolean fluidFilter = false;

    public ServerFilteringBehaviour(SmartBlockEntity be) {
        super(be);
        filter = FilterItemStack.empty();
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("Filter", FilterItemStack.CODEC, filter);
        view.method_71465("FilterAmount", count);
        view.method_71472("UpTo", upTo);
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        filter = view.method_71426("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        count = view.method_71424("FilterAmount", 0);
        upTo = view.method_71433("UpTo", false);

        // Migrate from previous behaviour
        if (count == 0) {
            upTo = true;
            count = getMaxStackSize();
        }

        super.read(view, clientPacket);
    }

    public ServerFilteringBehaviour withCallback(Consumer<class_1799> filterCallback) {
        callback = filterCallback;
        return this;
    }

    public ServerFilteringBehaviour withPredicate(Predicate<class_1799> filterPredicate) {
        predicate = filterPredicate;
        return this;
    }

    public ServerFilteringBehaviour forRecipes() {
        recipeFilter = true;
        return this;
    }

    public ServerFilteringBehaviour forFluids() {
        fluidFilter = true;
        return this;
    }

    public ServerFilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        showCountPredicate = condition;
        return this;
    }

    public ServerFilteringBehaviour showCount() {
        showCount = true;
        return this;
    }

    public boolean setFilter(class_2350 face, class_1799 stack) {
        return setFilter(stack);
    }

    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (!filter.method_7960() && !predicate.test(filter))
            return false;
        this.filter = FilterItemStack.of(filter);
        if (!upTo)
            count = Math.min(count, stack.method_7914());
        callback.accept(filter);
        blockEntity.method_5431();
        blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings settings, boolean ctrlDown) {
        if (getValueSettings().equals(settings))
            return;
        count = class_3532.method_15340(settings.value(), 1, getMaxStackSize());
        upTo = settings.row() == 0;
        blockEntity.method_5431();
        blockEntity.sendData();
        playFeedbackSound(this);
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(upTo ? 0 : 1, count == 0 ? getMaxStackSize() : count);
    }

    @Override
    public void destroy() {
        if (filter.isFilterItem()) {
            class_243 pos = VecHelper.getCenterOf(getPos());
            class_1937 world = getWorld();
            world.method_8649(new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, getFilter().method_7972()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (filter.isFilterItem())
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, getFilter());

        return ItemRequirement.NONE;
    }

    public int getMaxStackSize() {
        return getMaxStackSize(getFilter());
    }

    public int getMaxStackSize(class_2350 face) {
        return getMaxStackSize(getFilter(face));
    }

    public int getMaxStackSize(class_1799 filter) {
        if (filter.method_7960())
            return 64;
        return filter.method_7914();
    }

    public class_1799 getFilter(class_2350 side) {
        return getFilter();
    }

    public class_1799 getFilter() {
        return filter.item();
    }

    public boolean isCountVisible() {
        return showCountPredicate.get() && getMaxStackSize() > 1;
    }

    public boolean test(class_1799 stack) {
        return !isActive() || filter.test(blockEntity.method_10997(), stack);
    }

    public boolean test(FluidStack stack) {
        return !isActive() || filter.test(blockEntity.method_10997(), stack);
    }

    public boolean isActive() {
        return isActive.get();
    }

    public ServerFilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        isActive = condition;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public int getAmount() {
        return count;
    }

    public boolean anyAmount() {
        return count == 0;
    }

    @Override
    public String getClipboardKey() {
        return "Filtering";
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        ValueSettingsHandleBehaviour.super.writeToClipboard(view, side);
        class_1799 filter = getFilter(side);
        view.method_71468("Filter", class_1799.field_49266, filter);
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        if (!mayInteract(player))
            return false;
        boolean upstreamResult = ValueSettingsHandleBehaviour.super.readFromClipboard(view, player, side, simulate);
        Optional<class_1799> filterItem = view.method_71426("Filter", class_1799.field_49266);
        if (filterItem.isEmpty())
            return upstreamResult;
        if (simulate)
            return true;
        if (getWorld().field_9236)
            return true;

        class_1799 refund = class_1799.field_8037;
        class_1799 filter = getFilter(side);
        if (filter.method_7909() instanceof FilterItem && !player.method_68878())
            refund = filter.method_7972();

        class_1799 copied = filterItem.get();

        class_1661 inventory = player.method_31548();
        if (copied.method_7909() instanceof FilterItem filterType && !player.method_68878()) {
            if (refund.method_7909() == filterType) {
                setFilter(side, copied);
                return true;
            } else if (inventory.extract(filterType.method_7854()) == 1 || !inventory.extract(stack -> stack.method_7909() == filterType, 1)
                .method_7960()) {
                if (!refund.method_7960())
                    inventory.method_7398(refund);
                setFilter(side, copied);
                return true;
            }

            player.method_7353(
                class_2561.method_43469("create.logistics.filter.requires_item_in_inventory", copied.method_7964().method_27661().method_27692(class_124.field_1068))
                    .method_27692(class_124.field_1061), true
            );
            AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
            return false;
        }

        if (!refund.method_7960())
            inventory.method_7398(refund);

        return setFilter(side, copied);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        class_1937 level = getWorld();
        class_2338 pos = getPos();
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 toApply = itemInHand.method_7972();

        if (!canShortInteract(toApply))
            return;
        if (level.method_8608())
            return;

        class_1799 filter = getFilter(side);
        if (filter.method_7909() instanceof FilterItem) {
            class_1661 inventory = player.method_31548();
            if (!player.method_68878() || inventory.count(filter, 1) == 0)
                inventory.method_7398(filter.method_7972());
        }

        if (toApply.method_7909() instanceof FilterItem)
            toApply.method_7939(1);

        if (!setFilter(side, toApply)) {
            player.method_7353(class_2561.method_43471("create.logistics.filter.invalid_item"), true);
            AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
            return;
        }

        if (!player.method_68878()) {
            if (toApply.method_7909() instanceof FilterItem) {
                if (itemInHand.method_7947() == 1)
                    player.method_6122(hand, class_1799.field_8037);
                else
                    itemInHand.method_7934(1);
            }
        }

        level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, .25f, .1f);
    }

    public boolean canShortInteract(class_1799 toApply) {
        if (toApply.method_31574(AllItems.WRENCH))
            return false;
        return !toApply.method_31574(AllItems.MECHANICAL_ARM);
    }

    public boolean isRecipeFilter() {
        return recipeFilter;
    }

    @Override
    public int netId() {
        return 1;
    }
}
