package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class ServerSidedFilteringBehaviour extends ServerFilteringBehaviour {

    Map<class_2350, ServerFilteringBehaviour> sidedFilters;
    private final BiFunction<class_2350, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory;
    private final Predicate<class_2350> validDirections;
    private Consumer<class_2350> removeListener;

    public ServerSidedFilteringBehaviour(
        SmartBlockEntity be,
        BiFunction<class_2350, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory,
        Predicate<class_2350> validDirections
    ) {
        super(be);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        sidedFilters = new IdentityHashMap<>();
        updateFilterPresence();
    }

    public ServerFilteringBehaviour get(class_2350 side) {
        return sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        Set<class_2350> valid = new HashSet<>();
        for (class_2350 d : Iterate.directions)
            if (validDirections.test(d))
                valid.add(d);
        for (class_2350 d : Iterate.directions)
            if (valid.contains(d)) {
                if (!sidedFilters.containsKey(d))
                    sidedFilters.put(d, filterFactory.apply(d, new ServerFilteringBehaviour(blockEntity)));
            } else if (sidedFilters.containsKey(d))
                removeFilter(d);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        class_11372.class_11374 list = view.method_71476("Filters");
        sidedFilters.forEach((side, filter) -> {
            class_11372 item = list.method_71480();
            item.method_71468("Side", class_2350.field_29502, side);
            filter.write(item, clientPacket);
        });
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        view.method_71438("Filters").forEach(item -> {
            class_2350 side = item.method_71426("Side", class_2350.field_29502).orElseThrow();
            ServerFilteringBehaviour filter = sidedFilters.get(side);
            if (filter != null) {
                filter.read(item, clientPacket);
            }
        });
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        sidedFilters.values().forEach(ServerFilteringBehaviour::tick);
    }

    @Override
    public boolean setFilter(class_2350 side, class_1799 stack) {
        if (!sidedFilters.containsKey(side))
            return true;
        sidedFilters.get(side).setFilter(stack);
        return true;
    }

    @Override
    public class_1799 getFilter(class_2350 side) {
        if (!sidedFilters.containsKey(side))
            return class_1799.field_8037;
        return sidedFilters.get(side).getFilter();
    }

    public boolean test(class_2350 side, class_1799 stack) {
        if (!sidedFilters.containsKey(side))
            return true;
        return sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        sidedFilters.values().forEach(ServerFilteringBehaviour::destroy);
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return sidedFilters.values().stream().reduce(ItemRequirement.NONE, (a, b) -> a.union(b.getRequiredItems()), ItemRequirement::union);
    }

    public void removeFilter(class_2350 side) {
        if (!sidedFilters.containsKey(side))
            return;
        sidedFilters.remove(side).destroy();
        if (removeListener != null) {
            removeListener.accept(side);
        }
    }

    public void setRemoveListener(Consumer<class_2350> removeListener) {
        this.removeListener = removeListener;
    }
}
